/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wordssplugin.capabilities;

import aphia.v1_0.wordss.AphiaRecord;
import java.rmi.RemoteException;
import java.util.HashSet;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.plugin.fwk.capabilities.MappingCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.wordssplugin.WordssPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamesMappingImpl
implements MappingCapability {
    private static Logger logger = LoggerFactory.getLogger(NamesMappingImpl.class);

    public void getRelatedScientificNames(ObjectWriter<String> writer, String commonName) throws ExternalRepositoryException {
        try {
            AphiaRecord[] records;
            logger.debug("retrieving mapping for " + commonName);
            int offsetlimit = 50;
            int offset = 1;
            HashSet<String> snSet = new HashSet<String>();
            do {
                if ((records = WordssPlugin.binding.getAphiaRecordsByVernacular(commonName, true, offset)) != null) {
                    for (AphiaRecord record : records) {
                        if (!writer.isAlive()) {
                            return;
                        }
                        if (snSet.contains(record.getScientificname())) continue;
                        logger.trace("writing (COMMONNAMESMAPPING) " + record.getScientificname());
                        writer.write((Object)record.getScientificname());
                        snSet.add(record.getScientificname());
                    }
                }
                offset += 50;
            } while (records != null && records.length == 50);
        }
        catch (RemoteException e) {
            throw new ExternalRepositoryException((Throwable)e);
        }
    }
}

