/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wordssplugin.capabilities;

import aphia.v1_0.AphiaRecord;
import aphia.v1_0.Source;
import aphia.v1_0.Vernacular;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.Conditions;
import org.gcube.data.spd.model.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.model.exceptions.IdNotValidException;
import org.gcube.data.spd.model.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.writers.ClosableWriter;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.wordssplugin.Utils;
import org.gcube.data.spd.wordssplugin.WordssPlugin;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Conditions> getSupportedProperties() {
        return Collections.emptySet();
    }

    public List<TaxonomyItem> retrieveTaxonChildrenByTaxonId(String id) throws IdNotValidException, ExternalRepositoryException {
        ArrayList<TaxonomyItem> list = new ArrayList<TaxonomyItem>();
        try {
            AphiaRecord[] records;
            int offsetlimit = 50;
            int offset = 1;
            do {
                if ((records = WordssPlugin.binding.getAphiaChildrenByID(Integer.parseInt(id), offset)) != null) {
                    for (AphiaRecord record : records) {
                        TaxonomyItem item = this.createItem(record, false);
                        if (item == null) continue;
                        list.add(item);
                    }
                }
                offset += 50;
            } while (records != null && records.length == 50);
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"id not valid", (Throwable)e);
            throw new IdNotValidException((Throwable)e);
        }
        catch (Throwable e) {
            this.logger.error((Object)"error contacting worms service", e);
            throw new ExternalRepositoryException(e);
        }
        return list;
    }

    public void retrieveTaxa(ObjectWriter<TaxonomyItem> writer, String word) {
        HashSet<Integer> hash = new HashSet<Integer>();
        try {
            AphiaRecord[] records = null;
            int offsetlimit = 50;
            int offset = 1;
            do {
                if ((records = WordssPlugin.binding.getAphiaRecords(word, true, false, false, offset)) != null) {
                    for (AphiaRecord record : records) {
                        if (hash.contains(record.getAphiaID())) continue;
                        hash.add(record.getAphiaID());
                        TaxonomyItem item = this.createItem(record, true);
                        if (item == null || !writer.isAlive()) continue;
                        writer.write((Object)item);
                    }
                }
                offset += 50;
            } while (records != null && records.length == 50);
        }
        catch (Throwable e) {
            this.logger.error((Object)"error contacting worms service", e);
        }
    }

    private TaxonomyItem createItem(AphiaRecord record, Boolean flag) throws RemoteException {
        TaxonomyItem item = null;
        String scientificname = record.getScientificname();
        if (scientificname != null) {
            item = new TaxonomyItem(record.getAphiaID() + "");
            item.setScientificName(record.getScientificname());
            item.setAuthor(record.getAuthority());
            item.setLsid(record.getLsid());
            item.setCredits(Utils.createCredits());
            item.setCitation(record.getCitation());
            item.setRank(record.getRank());
            ArrayList<CommonName> listCommNames = new ArrayList<CommonName>();
            Vernacular[] vernaculars = WordssPlugin.binding.getAphiaVernacularsByID(record.getAphiaID());
            if (vernaculars != null) {
                for (Vernacular vernacular : vernaculars) {
                    if (vernacular.getLanguage_code() == null) continue;
                    CommonName a = new CommonName(vernacular.getLanguage(), vernacular.getVernacular());
                    listCommNames.add(a);
                }
            }
            item.setCommonNames(listCommNames);
            try {
                if (record.getStatus().equals("accepted")) {
                    item.setStatus(new TaxonomyStatus("accepted", TaxonomyStatus.Status.ACCEPTED));
                } else if (record.getStatus().equals("unaccepted") && WordssPlugin.binding.getAphiaRecordByID(record.getValid_AphiaID()).getStatus().equals("accepted")) {
                    item.setStatus(new TaxonomyStatus(TaxonomyStatus.Status.SYNONYM, record.getValid_AphiaID() + "", "synonym"));
                } else {
                    item.setStatus(new TaxonomyStatus(record.getStatus(), TaxonomyStatus.Status.UNKNOWN));
                }
            }
            catch (Exception e) {
                item.setStatus(new TaxonomyStatus(record.getStatus(), TaxonomyStatus.Status.UNKNOWN));
            }
            if (flag.booleanValue()) {
                try {
                    item.setParent(Utils.retrieveTaxonomy(WordssPlugin.binding.getAphiaClassificationByID(record.getAphiaID()), record.getAphiaID()));
                }
                catch (Exception e) {
                    item.setParent(null);
                }
            } else {
                item.setParent(null);
            }
            Source[] sources = null;
            sources = WordssPlugin.binding.getSourcesByAphiaID(record.getAphiaID());
            if (sources != null) {
                for (Source source : sources) {
                    if (source == null || source.getReference() == null) continue;
                    StringBuilder p = new StringBuilder();
                    p.append(source.getReference());
                    if (source.getLink() != null) {
                        p.append(", available online at ");
                        p.append(source.getLink());
                    }
                    if (source.getUrl() != null) {
                        p.append(", details: ");
                        p.append(source.getUrl());
                    }
                    ElementProperty property = new ElementProperty(source.getUse(), p.toString());
                    item.addProperty(property);
                }
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveTaxonByIds(Iterator<String> ids, ClosableWriter<TaxonomyItem> writer) {
        try {
            String id;
            TaxonomyItem tax;
            while (ids.hasNext() && (tax = this.retrieveTaxonById(id = ids.next())) != null && writer.isAlive()) {
                writer.write((Object)tax);
            }
        }
        catch (IdNotValidException e) {
            this.logger.error((Object)"IdNotValidn", (Throwable)e);
        }
        catch (ExternalRepositoryException e) {
            this.logger.error((Object)"ExternalRepositoryException", (Throwable)e);
        }
        finally {
            writer.close();
        }
    }

    public TaxonomyItem retrieveTaxonById(String id) throws IdNotValidException, ExternalRepositoryException {
        TaxonomyItem tax = null;
        AphiaRecord record = null;
        try {
            record = WordssPlugin.binding.getAphiaRecordByID(Integer.parseInt(id));
            if (record != null) {
                tax = this.createItem(record, true);
            }
        }
        catch (NumberFormatException e) {
            this.logger.error((Object)"NumberFormatException", (Throwable)e);
        }
        catch (RemoteException e) {
            this.logger.error((Object)"Remote Error", (Throwable)e);
        }
        return tax;
    }

    public void getSynonymnsById(ObjectWriter<TaxonomyItem> writer, String id) throws IdNotValidException, MethodNotSupportedException {
        try {
            AphiaRecord[] records = null;
            records = WordssPlugin.binding.getAphiaSynonymsByID(Integer.parseInt(id));
            if (records != null) {
                AphiaRecord record;
                TaxonomyItem tax;
                AphiaRecord[] arr$ = records;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (tax = this.createItem(record = arr$[i$], true)) != null && writer.isAlive(); ++i$) {
                    writer.write((Object)tax);
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"General Error", (Throwable)e);
        }
    }

    public void searchByScientificName(String word, ObjectWriter<TaxonomyItem> writer, Condition ... properties) {
        this.retrieveTaxa(writer, word);
    }
}

