/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.wordssplugin;

import aphia.v1_0.AphiaNameServiceBindingStub;
import aphia.v1_0.AphiaNameServiceLocator;
import aphia.v1_0.AphiaRecord;
import aphia.v1_0.Source;
import aphia.v1_0.Vernacular;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.rpc.ServiceException;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.RepositoryInfo;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.Product;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.plugin.fwk.AbstractPlugin;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.ExpansionCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.MappingCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.wordssplugin.Utils;
import org.gcube.data.spd.wordssplugin.capabilities.ClassificationCapabilityImpl;
import org.gcube.data.spd.wordssplugin.capabilities.ExpansionCapabilityImpl;
import org.gcube.data.spd.wordssplugin.capabilities.NamesMappingImpl;

public class WordssPlugin
extends AbstractPlugin {
    private GCUBELog logger = new GCUBELog(WordssPlugin.class);
    public static String credits = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with the World Register of Deep-Sea Species (WoRDSS) (http://www.marinespecies.org/deepsea/)";
    public static AphiaNameServiceBindingStub binding;
    public static String baseurl;

    public void initialize(ServiceEndpoint res) throws Exception {
        this.setUseCache(true);
        try {
            for (ServiceEndpoint.AccessPoint ap : res.profile().accessPoints()) {
                if (!ap.name().equals("portType")) continue;
                baseurl = ap.address();
            }
            binding = (AphiaNameServiceBindingStub)new AphiaNameServiceLocator().getAphiaNameServicePort();
        }
        catch (ServiceException jre) {
            this.logger.error((Object)"error contacting WoRDSS service", (Throwable)jre);
            throw jre;
        }
        super.initialize(res);
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return new HashSet<Capabilities>(){
            {
                this.add(Capabilities.Classification);
                this.add(Capabilities.NamesMapping);
                this.add(Capabilities.Synonims);
            }
        };
    }

    public ClassificationCapability getClassificationInterface() {
        return new ClassificationCapabilityImpl();
    }

    public MappingCapability getMappingInterface() {
        return new NamesMappingImpl();
    }

    public ExpansionCapability getSynonymCapability() {
        return new ExpansionCapabilityImpl();
    }

    public void searchByScientificName(String word, ObjectWriter<ResultItem> writer, Condition ... properties) {
        this.search(word, writer);
    }

    public String getRepositoryName() {
        return "WoRDSS";
    }

    public String getDescription() {
        return "Plugin for WoRDSS";
    }

    public void search(String word, ObjectWriter<ResultItem> writer) {
        try {
            DataProvider dp = new DataProvider("WoRDSS");
            dp.setName("WoRDSS");
            AphiaRecord[] records = null;
            ArrayList<CommonName> listCommNames = new ArrayList<CommonName>();
            int offsetlimit = 50;
            int offset = 1;
            do {
                if ((records = binding.getAphiaRecords(word, true, false, false, offset)) != null) {
                    block3: for (AphiaRecord record : records) {
                        Source[] sources = null;
                        if (record == null || (sources = binding.getSourcesByAphiaID(record.getAphiaID())) == null) continue;
                        for (Source source : sources) {
                            Vernacular[] vernaculars;
                            if (source == null || source.getReference() == null) continue;
                            DataSet ds = new DataSet(record.getAphiaID() + "||" + source.getReference().hashCode());
                            ds.setName(source.getReference());
                            if (source.getUrl() != null) {
                                ds.setCitation(source.getUrl());
                            }
                            ds.setDataProvider(dp);
                            ResultItem item = new ResultItem(record.getAphiaID() + "", record.getScientificname());
                            AphiaRecord[] synonyms = binding.getAphiaSynonymsByID(record.getAphiaID());
                            if (synonyms != null && synonyms.length > 0) {
                                Product product = new Product(Capabilities.Synonims, item.getId());
                                product.setCount(synonyms.length);
                                item.setProducts(Collections.singletonList(product));
                            }
                            if ((vernaculars = binding.getAphiaVernacularsByID(record.getAphiaID())) != null) {
                                for (Vernacular vernacular : vernaculars) {
                                    if (vernacular.getLanguage_code() == null) continue;
                                    CommonName a = new CommonName(vernacular.getLanguage(), vernacular.getVernacular());
                                    listCommNames.add(a);
                                }
                            }
                            item.setAuthor(record.getAuthority());
                            item.setLsid(record.getLsid());
                            item.setCitation(record.getCitation());
                            item.setCredits(Utils.createCredits());
                            item.setCommonNames(listCommNames);
                            item.setDataSet(ds);
                            item.setRank(record.getRank());
                            item.setParent(Utils.retrieveTaxon(binding.getAphiaClassificationByID(record.getAphiaID()), record.getAphiaID()));
                            if (!writer.isAlive()) continue block3;
                            writer.write((Object)item);
                        }
                    }
                }
                offset += 50;
            } while (records != null && records.length == 50);
        }
        catch (Throwable e) {
            this.logger.error((Object)"error contacting WoRDSS service", e);
        }
    }

    public RepositoryInfo getRepositoryInfo() {
        RepositoryInfo info = new RepositoryInfo("http://www.marinespecies.org/deepsea/images/banner.png", "http://www.marinespecies.org/deepsea/", "The World Register of Deep-Sea Species (WoRDSS) is a taxonomic database of deep-sea species based on the World Register of Marine Species (WoRMS). This site was launched in December 2012 as a project of the International Network for Scientific Investigation of Deep-sea Ecosystems (INDEEP).");
        return info;
    }
}

