package org.gcube.data.spd.parser;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

import org.gcube.common.core.utils.logging.GCUBELog;

public class DarwinSimpleRecord {

	GCUBELog logger = new GCUBELog(DarwinSimpleRecord.class);

	public String occurrenceID;
	public Calendar modified;
	public Calendar eventTime;
	public String basisOfRecord;
	public String institutionCode;
	public String collectionID;
	public String collectionCode;
	public String catalogNumber;
	public String recordedBy;
	public String remarks;
	public String scientificName;
	public String scientificNameAuthorship;
	public String kingdom;
	public String phylum;
	public String clazz;
	public String order;
	public String family;
	public String genus;
	public String specificEpithet;
	public String infraspecificEpithet;
	public String authorYearOfScientificName;
	public String continent;
	public String country;
	public String locality;
	public String stateProvince;
	public String minimumElevationInMeters;
	public String maximumElevationInMeters;
	public String minimumDepthInMeters;
	public String maximumDepthInMeters;
	public String dayOfYear;
	public String collector;
	public String sex;
	public String decimalLatitude;
	public String decimalLongitude;
	public String verbatimLatitude;
	public String verbatimLongitude;
	public String identifiedBy;
	public String collectorNumber;
	public String fieldNumber;
	public String typeStatus;
	public String individualCount;
	public static SimpleDateFormat df=new SimpleDateFormat("yyyy-mm-dd hh:mm:ss");



	public DarwinSimpleRecord(XMLEventReader eventReader){
		//		System.out.println("DarwinSimpleRecord  " + eventReader);	

		while (eventReader.hasNext()){
			XMLEvent event = null;
			try {
				event = eventReader.nextEvent();
			} catch (XMLStreamException e) {
				logger.error("XMLStreamException", e);
			}
//			   StartElement startElement = event.asStartElement();
//		        System.out.println(startElement.getName().getLocalPart());
							
			if (Utils.checkStartElement(event, "occurrenceID")){			
				try {
					this.occurrenceID = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
			}else if (Utils.checkStartElement(event, "collectionID")){	
				try {
					this.collectionID = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;

			}else if (Utils.checkStartElement(event, "recordedBy")){	
				try {
					this.recordedBy = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "scientificNameAuthorship")){	
				try {
					this.scientificNameAuthorship = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "scientificName")){	
				try {
					this.scientificName = Utils.readCharacters(eventReader);
//					System.out.println(this.scientificName);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "authorYearOfScientificName")){	
				try {
					this.authorYearOfScientificName = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "basisOfRecord")){		
				try {
					
					this.basisOfRecord = Utils.readCharacters(eventReader);
//					System.out.println(this.basisOfRecord);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "catalogNumber")){	
				try {
					this.catalogNumber = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "class")){	
				try {
					this.clazz = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "collectionCode")){	
				try {
					this.collectionCode = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "collector")){	
				try {
					this.collector = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "collectorNumber")){	
				try {
					this.collectorNumber = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "continent")){	
				try {
					this.continent = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "country")){	
				try {
					this.country = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
	
			}else if (Utils.checkStartElement(event, "modified")){	
				String modifiedDate = null;
				try {
					modifiedDate = Utils.readCharacters(eventReader);
					if (modifiedDate!=null)
						this.modified = getCalendar(modifiedDate);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "eventTime")){	
				String eventTimeDate = null;
				try {
					eventTimeDate = Utils.readCharacters(eventReader);
					if (eventTimeDate!=null)
						this.eventTime = getCalendar(eventTimeDate);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;


			}else if (Utils.checkStartElement(event, "dayOfYear")){	
				try {
					this.dayOfYear = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "family")){	
				try {
					this.family = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "fieldNumber")){	
				try {
					this.fieldNumber = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "genus")){	
				try {
					this.genus = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;		
				
			}else if (Utils.checkStartElement(event, "identifiedBy")){	
				try {
					this.identifiedBy = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;	
				
				
			}else if (Utils.checkStartElement(event, "individualCount")){	
				try {
					this.individualCount = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;	

			}else if (Utils.checkStartElement(event, "infraspecificEpithet")){	
				try {
					this.infraspecificEpithet = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "institutionCode")){	
				try {
					this.institutionCode = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "kingdom")){	
				try {
					this.kingdom = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "locality")){	
				try {
					this.locality = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "order")){	
				try {
					this.order = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "phylum")){	
				try {
					this.phylum = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
		
				
			}else if (Utils.checkStartElement(event, "remarks")){	
				try {
					this.remarks = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "sex")){	
				try {
					this.sex = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "specificEpithet")){	
				try {
					this.specificEpithet = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;

			}else if (Utils.checkStartElement(event, "stateProvince")){	
				try {
					this.stateProvince = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "typeStatus")){	
				try {
					this.typeStatus = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;

			}else if (Utils.checkStartElement(event, "decimalLatitude")){	
				try {
					this.decimalLatitude = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "decimalLongitude")){	
				try {
					this.decimalLongitude = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "maximumDepthInMeters")){	
				try {
					this.maximumDepthInMeters = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "minimumDepthInMeters")){	
				try {
					this.minimumDepthInMeters = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "maximumElevationInMeters")){	
				try {
					this.maximumElevationInMeters = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "minimumElevationInMeters")){	
				try {
					this.minimumElevationInMeters = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
			}else if (Utils.checkStartElement(event, "verbatimLatitude")){	
				try {
					this.verbatimLatitude = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				
				
			}else if (Utils.checkStartElement(event, "verbatimLongitude")){	
				try {
					this.verbatimLongitude = Utils.readCharacters(eventReader);
				} catch (Exception e) {
					logger.error("Exception", e);
				}
				continue;
				

			} else if (Utils.checkEndElement(event, "SimpleDarwinRecord")){	
//				System.out.println("</SimpleDarwinRecord>");	
				break;
			}
		}
		
		
	}

	private Calendar getCalendar(String myDate) {
		Calendar dateC = null;
		try {

			myDate = myDate.replace("T", " ");
			dateC = dateString2Calendar(myDate);

		} catch (ParseException e) {
			logger.error("ParseException" , e);
		}
		return dateC;
	}


//	//Returns the tag value
//	private String getTagValue(String sTag, Element eElement){	
//		String a = "";
//
//		//	NodeList nlList = eElement.getElementsByTagName(sTag).item(0).getChildNodes();
//
//		NodeList nlList = eElement.getElementsByTagName(sTag);
//		if (nlList!= null){	
//			Element xmlNode = (Element)nlList.item(0);
//			if (xmlNode != null){
//				NodeList textFNList = xmlNode.getChildNodes();
//				if (textFNList != null){
//					Node nValue = (Node) textFNList.item(0);  
//					if (nValue != null)						
//						a = nValue.getNodeValue(); 				
//				}
//			}
//		}
//		// System.out.println(a);
//		return a;
//	}


	private Calendar dateString2Calendar(String s) throws ParseException {
		Calendar cal=Calendar.getInstance();
		try{
			Date d1=df.parse(s);
			cal.setTime(d1);
		}
		catch (Exception e) {
			return null;
		}
		return cal;
	}

}
