package org.gcube.data.spd.parser;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RecordsIterator implements Iterator<DarwinRecord> {

	GCUBELog logger = new GCUBELog(RecordsIterator.class);

	public final int limit = 10;
	public NodeList sum = null;
	public int start = 0;
	public int count = 0;
	public String pathUrl = null;
	public int i = -1;
	public NodeList nList = null;
	public String filter;
	public String baseurl;
	public String model;

	public DocumentBuilderFactory dbFactory;
	public DocumentBuilder dBuilder;
	public Document doc;

	public RecordsIterator(String baseurl, String filter, String model) {
		//		count = 0;
		//		i = -1;
		//		start = 0;
		this.baseurl = baseurl;
		this.filter = filter;
		this.model = model;
		pathUrl = baseurl + "?op=search&start=" + start + "&limit=" + limit + "&filter=" + filter + "&model=" + model;

		//		System.out.println(pathUrl);
	}


	public DarwinRecord next() {

		DarwinRecord dr = null;
		Element eElement = null;	

		if (( i < nList.getLength() ) && ( nList.getLength() > 0 )) {

			Node nNode = nList.item(i);
			if (nNode.getNodeType() == Node.ELEMENT_NODE) {

				eElement = (Element) nNode;
				dr = new DarwinRecord(eElement);
			}
		}

		return dr;
	}


	//Returns true if the iteration has more elements
	public boolean hasNext() 
	{		
		i++;		
		//				System.out.println(i + " < " + nList.getLength());
		if (nList != null){
			if (nList.getLength() == 0)
				return false;

			else if (i < nList.getLength())
				return true;
			else
			{	
				try
				{				
					pathUrl = "";
					sum = doc.getElementsByTagName("summary");

					if( sum.getLength() > 0) {

						Node nNode = sum.item(0);
						if (nNode.getNodeType() == Node.ELEMENT_NODE) {

							Element el = (Element) nNode;

							if (el.getAttribute("next") != ""){		
								count++;	
								pathUrl = baseurl + "?op=search&start=" + ( limit * count) + "&limit=" +  limit + "&filter=" + filter + "&model=" + model;
//								System.out.println(pathUrl);		    	  	
								doc = (Document) dBuilder.parse(new URL(pathUrl).openStream());
								doc.getDocumentElement().normalize();	
								nList = getDoc(doc);

								i = -1;
								//return true;
								return hasNext();
							}
						}				
					}
				} catch (Exception e) {
					logger.error("Error opening stream", e);
				}
			}
		}

		return false;		
	}



	//The remove operation is not supported by this Iterator
	public void remove() {
		throw new UnsupportedOperationException();
	}


	//Get XML document
	public RecordsIterator iterator(){

		try 
		{			
			dbFactory = DocumentBuilderFactory.newInstance();
			dBuilder = dbFactory.newDocumentBuilder();
			doc = (Document) dBuilder.parse(new URL(pathUrl).openStream());
			doc.getDocumentElement().normalize();	
			nList = getDoc(doc);

		} catch (ParserConfigurationException e) {		
			logger.error("ParserConfigurationException", e);
		} catch (MalformedURLException e) {
			logger.error("Error MalformedURL", e);
		} catch (SAXException e) {
			logger.error("Error elaborating XML", e);
		} catch (IOException e) {		
			logger.error("Error opening stream", e);
		}

		return this;
	}


	public NodeList getDoc (Document doc){
		try 
		{			
			nList = doc.getElementsByTagName("dwrec:DarwinRecord");		
		} catch (Exception e) {
			e.printStackTrace();
		}
		return nList;
	}


}
