/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.spql.model.where;

import java.util.Collections;
import java.util.List;
import org.gcube.dataaccess.spql.model.CheckableElement;
import org.gcube.dataaccess.spql.model.RelationalOperator;
import org.gcube.dataaccess.spql.model.error.InvalidValueError;
import org.gcube.dataaccess.spql.model.error.QueryError;
import org.gcube.dataaccess.spql.model.where.ConditionParameter;
import org.gcube.dataaccess.spql.model.where.ParsableValue;

public class Condition
implements CheckableElement {
    protected ConditionParameter parameter;
    protected RelationalOperator operator;
    protected ParsableValue<?> value;

    public Condition() {
    }

    public Condition(ConditionParameter parameter, RelationalOperator operator, ParsableValue<?> value) {
        this.parameter = parameter;
        this.operator = operator;
        this.value = value;
    }

    public ConditionParameter getParameter() {
        return this.parameter;
    }

    public void setParameter(ConditionParameter parameter) {
        this.parameter = parameter;
    }

    public RelationalOperator getOperator() {
        return this.operator;
    }

    public void setOperator(RelationalOperator operator) {
        this.operator = operator;
    }

    public ParsableValue<?> getValue() {
        return this.value;
    }

    public void setValue(ParsableValue<?> value) {
        this.value = value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Condition [parameter=");
        builder.append((Object)this.parameter);
        builder.append(", operator=");
        builder.append((Object)this.operator);
        builder.append(", value=");
        builder.append(this.value);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public List<QueryError> check() {
        try {
            this.value.parse();
            return Collections.emptyList();
        }
        catch (Exception e) {
            return Collections.singletonList(new InvalidValueError("Invalid value \"" + this.value.getTextValue() + "\"" + e.getMessage()));
        }
    }
}

