/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataaccess.spql.stmt;

import org.gcube.dataaccess.spql.model.ReturnType;

public abstract class AbstractStatement {
    protected StringBuilder query = new StringBuilder();

    protected AbstractStatement(StringBuilder query) {
        this.query = query;
    }

    protected void appendNames(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            this.query.append('\'');
            this.query.append(names[i]);
            this.query.append('\'');
            if (i + 1 >= names.length) continue;
            this.query.append(", ");
        }
    }

    public String toQuery() {
        return this.query.toString();
    }

    public String returnType(ReturnType type) {
        switch (type) {
            case ALL: {
                this.query.append(" return *");
                break;
            }
            case OCCURRENCE: {
                this.query.append(" return Occurrence");
                break;
            }
            case TAXON: {
                this.query.append(" return Taxon");
            }
        }
        return this.toQuery();
    }
}

