/**
 * 
 */
package org.gcube.dataaccess.spql.stmt;

import org.gcube.dataaccess.spql.model.ReturnType;

/**
 * @author "Federico De Faveri defaveri@isti.cnr.it"
 *
 */
public abstract class AbstractStatement {
	
	protected StringBuilder query = new StringBuilder();

	/**
	 * @param query
	 */
	protected AbstractStatement(StringBuilder query) {
		this.query = query;
	}
	
	protected void appendNames(String[] names)
	{
		for (int i = 0; i < names.length; i++) {
			query.append('\'');
			query.append(names[i]);
			query.append('\'');
			if (i+1<names.length) query.append(", ");
		}
	}
	
	public String toQuery()
	{
		return query.toString();
	}
	
	public String returnType(ReturnType type)
	{
		switch (type) {
			case ALL: query.append(" return *"); break;
			case OCCURRENCE: query.append(" return Occurrence"); break;
			case TAXON: query.append(" return Taxon"); break;
		}
		
		return toQuery();
	}

}
