/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.specieslink;

import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.parser.DarwinRecord;
import org.gcube.data.spd.parser.RecordsIterator;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.StreamBlockingException;
import org.gcube.data.spd.plugin.fwk.exceptions.StreamException;
import org.gcube.data.spd.plugin.fwk.model.BasisOfRecord;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.readers.LocalReader;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.specieslink.SpeciesLinkPlugin;
import org.gcube.data.spd.specieslink.Utils;

public class OccurrencesCapabilityImpl
extends OccurrencesCapability {
    GCUBELog logger = new GCUBELog(OccurrencesCapabilityImpl.class);

    public Set<Properties> getSupportedProperties() {
        return new HashSet<Properties>(){
            {
                this.add(Properties.DateFrom);
                this.add(Properties.DateTo);
                this.add(Properties.CoordinateFrom);
                this.add(Properties.CoordinateTo);
            }
        };
    }

    private static BasisOfRecord matchBasisOfRecord(String value) {
        BasisOfRecord[] basisOfRecordArray = BasisOfRecord.values();
        int n = basisOfRecordArray.length;
        int n2 = 0;
        while (n2 < n) {
            BasisOfRecord record = basisOfRecordArray[n2];
            if (record.name().toLowerCase().equals(value.toLowerCase())) {
                return record;
            }
            ++n2;
        }
        if (value.toLowerCase().equals("S".toLowerCase())) {
            return BasisOfRecord.PreservedSpecimen;
        }
        if (value.toLowerCase().equals("Fotot".toLowerCase())) {
            return BasisOfRecord.MachineObservation;
        }
        return BasisOfRecord.HumanObservation;
    }

    public void searchByCommonName(String word, ObjectWriter<OccurrencePoint> writer, Property ... properties) {
    }

    public void searchByScientificName(String scientificName, ObjectWriter<OccurrencePoint> writer, Property ... properties) {
        this.logger.trace((Object)("searchByScientificName " + scientificName + " in SpeciesLink"));
        String f = "";
        try {
            f = Utils.elaborateProps(properties);
        }
        catch (Exception e) {
            this.logger.error((Object)"error elaborating properties", (Throwable)e);
            writer.close();
            return;
        }
        String filter = "http://rs.tdwg.org/dwc/dwcore/ScientificName%20like%20%22" + scientificName.replace(" ", "%20") + "%22" + f + "&orderBy=http://rs.tdwg.org/dwc/dwcore/ScientificName";
        RecordsIterator set = new RecordsIterator(SpeciesLinkPlugin.baseurl, filter, SpeciesLinkPlugin.model);
        RecordsIterator it = set.iterator();
        DarwinRecord element = null;
        try {
            try {
                while (it.hasNext()) {
                    element = (DarwinRecord)it.next();
                    OccurrencePoint a = new OccurrencePoint(String.valueOf(element.globalUniqueIdentifier));
                    a.setBasisOfRecord(OccurrencesCapabilityImpl.matchBasisOfRecord(element.basisOfRecord));
                    a.setCatalogueNumber(element.catalogNumber);
                    a.setCitation(element.identifiedBy);
                    a.setCollectionCode(element.collectionCode);
                    a.setCountry(element.country);
                    a.setDecimalLatitude(element.decimalLatitude);
                    a.setDecimalLongitude(element.decimalLongitude);
                    a.setEventDate(null);
                    a.setFamily(element.family);
                    a.setInstitutionCode(element.institutionCode);
                    a.setKingdom(element.kingdom);
                    a.setLocality(element.country);
                    a.setMaxDepth((double)element.maximumDepthInMeters);
                    a.setMinDepth((double)element.minimumDepthInMeters);
                    a.setModified(element.dateLastModified);
                    a.setRecordedBy(element.identifiedBy);
                    a.setScientificName(element.scientificName);
                    writer.put((Object)a);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"General Error", (Throwable)e);
                writer.put((StreamException)new StreamBlockingException());
                writer.close();
            }
        }
        finally {
            writer.close();
        }
    }

    public void getOccurrencesByIds(ObjectWriter<OccurrencePoint> writer, LocalReader<String> ids) {
        try {
            try {
                while (ids.hasNext()) {
                    String id = (String)ids.next();
                    this.logger.trace((Object)("getOccurrencesByIds " + id + " in SpeciesLink"));
                    String filter = "http://rs.tdwg.org/dwc/dwcore/GlobalUniqueIdentifier%20equals%20%22" + id + "%22";
                    RecordsIterator set = new RecordsIterator(SpeciesLinkPlugin.baseurl, filter, SpeciesLinkPlugin.model);
                    RecordsIterator it = set.iterator();
                    DarwinRecord element = null;
                    while (it.hasNext()) {
                        element = (DarwinRecord)it.next();
                        OccurrencePoint a = new OccurrencePoint(id);
                        a.setBasisOfRecord(OccurrencesCapabilityImpl.matchBasisOfRecord(element.basisOfRecord));
                        a.setCatalogueNumber(element.catalogNumber);
                        a.setCitation(element.identifiedBy);
                        a.setCollectionCode(element.collectionCode);
                        a.setCountry(element.country);
                        a.setDecimalLatitude(element.decimalLatitude);
                        a.setDecimalLongitude(element.decimalLongitude);
                        a.setEventDate(null);
                        a.setFamily(element.family);
                        a.setInstitutionCode(element.institutionCode);
                        a.setKingdom(element.kingdom);
                        a.setLocality(element.country);
                        a.setMaxDepth((double)element.maximumDepthInMeters);
                        a.setMinDepth((double)element.minimumDepthInMeters);
                        a.setModified(element.dateLastModified);
                        a.setRecordedBy(element.identifiedBy);
                        a.setScientificName(element.scientificName);
                        writer.put((Object)a);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"General Error", (Throwable)e);
                writer.put((StreamException)new StreamBlockingException());
                writer.close();
            }
        }
        finally {
            writer.close();
        }
    }

    public void getOccurrencesByProductKeys(ObjectWriter<OccurrencePoint> writer, LocalReader<String> keys) {
        try {
            try {
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.logger.trace((Object)("getOccurrencesByProductKeys " + key + " in SpeciesLink"));
                    RecordsIterator set = new RecordsIterator(SpeciesLinkPlugin.baseurl, key, SpeciesLinkPlugin.model);
                    RecordsIterator it = set.iterator();
                    DarwinRecord element = null;
                    while (it.hasNext()) {
                        element = (DarwinRecord)it.next();
                        OccurrencePoint a = new OccurrencePoint(String.valueOf(element.globalUniqueIdentifier));
                        a.setBasisOfRecord(OccurrencesCapabilityImpl.matchBasisOfRecord(element.basisOfRecord));
                        a.setCatalogueNumber(element.catalogNumber);
                        a.setCitation(element.identifiedBy);
                        a.setCollectionCode(element.collectionCode);
                        a.setCountry(element.country);
                        a.setDecimalLatitude(element.decimalLatitude);
                        a.setDecimalLongitude(element.decimalLongitude);
                        a.setEventDate(null);
                        a.setFamily(element.family);
                        a.setInstitutionCode(element.institutionCode);
                        a.setKingdom(element.kingdom);
                        a.setLocality(element.country);
                        a.setMaxDepth((double)element.maximumDepthInMeters);
                        a.setMinDepth((double)element.minimumDepthInMeters);
                        a.setModified(element.dateLastModified);
                        a.setRecordedBy(element.identifiedBy);
                        a.setScientificName(element.scientificName);
                        writer.put((Object)a);
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"General Error", (Throwable)e);
                writer.put((StreamException)new StreamBlockingException());
                writer.close();
            }
        }
        finally {
            writer.close();
        }
    }
}

