/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.plugin.fwk.writers.rswrapper;

import org.gcube.data.spd.model.exceptions.InvalidRecordException;
import org.gcube.data.spd.model.exceptions.WrapperAlreadyDisposedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWrapper<T> {
    Logger logger = LoggerFactory.getLogger(AbstractWrapper.class);
    protected int links;

    public abstract String getLocator() throws Exception;

    public abstract boolean add(T var1) throws InvalidRecordException, WrapperAlreadyDisposedException;

    public abstract void close();

    public synchronized void unregister() {
        this.logger.info(String.valueOf(Thread.currentThread().getId()) + " - closing wrapper");
        --this.links;
        if (this.links <= 0) {
            if (!this.isClosed()) {
                this.close();
            } else {
                throw new IllegalStateException("wrapper already closed");
            }
        }
    }

    public synchronized void register() {
        ++this.links;
    }

    public abstract boolean isClosed();
}

