/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.plugin.fwk.writers;

import org.gcube.data.spd.model.exceptions.InvalidRecordException;
import org.gcube.data.spd.model.exceptions.StreamException;
import org.gcube.data.spd.model.exceptions.WrapperAlreadyDisposedException;
import org.gcube.data.spd.plugin.fwk.writers.AbstractWriter;
import org.gcube.data.spd.plugin.fwk.writers.WriterManager;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.AbstractWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Writer<F>
extends AbstractWriter<F> {
    private static final Logger logger = LoggerFactory.getLogger(Writer.class);
    private WriterManager<F> manager = new DefaultWriter();

    public Writer(AbstractWrapper<F> wrapper) {
        super(wrapper);
    }

    public Writer(AbstractWrapper<F> wrapper, WriterManager<F> manager) {
        super(wrapper);
        this.manager = manager;
    }

    @Override
    public synchronized boolean write(F t) {
        if (this.getWrapper().isClosed()) {
            return false;
        }
        if (this.manager.filter(t)) {
            try {
                this.getWrapper().add(this.manager.enrich(t));
            }
            catch (InvalidRecordException e) {
                logger.warn("error putting a result in the Writer", (Throwable)e);
                return false;
            }
            catch (WrapperAlreadyDisposedException e) {
                logger.warn("wrapper already disposed", (Throwable)e);
                return false;
            }
        } else {
            logger.debug("a result has been filtered");
            return false;
        }
        ++this.wrote;
        return true;
    }

    @Override
    public synchronized boolean write(StreamException error) {
        return true;
    }

    @Override
    public boolean isAlive() {
        return !this.getWrapper().isClosed();
    }

    public class DefaultWriter
    extends WriterManager<F> {
    }
}

