/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.plugin.fwk.writers.rswrapper;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.commons.server.PortRange;
import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.commons.server.TCPConnectionManagerConfig;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.IWriterProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPStoreConnectionHandler;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPWriterProxy;
import gr.uoa.di.madgik.grs.record.GenericRecord;
import gr.uoa.di.madgik.grs.record.GenericRecordDefinition;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.record.field.FieldDefinition;
import gr.uoa.di.madgik.grs.record.field.StringField;
import gr.uoa.di.madgik.grs.record.field.StringFieldDefinition;
import gr.uoa.di.madgik.grs.writer.GRS2WriterException;
import gr.uoa.di.madgik.grs.writer.RecordWriter;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBException;
import org.gcube.data.spd.model.binding.Bindings;
import org.gcube.data.spd.model.exceptions.InvalidRecordException;
import org.gcube.data.spd.model.exceptions.WrapperAlreadyDisposedException;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.AbstractWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultWrapper<T>
extends AbstractWrapper<T> {
    private static final Logger logger;
    private RecordWriter<GenericRecord> writer = null;

    public ResultWrapper() throws Exception {
        StringFieldDefinition fieldDefinition = new StringFieldDefinition("result");
        RecordDefinition[] defs = new RecordDefinition[]{new GenericRecordDefinition(new FieldDefinition[]{fieldDefinition})};
        this.writer = new RecordWriter((IWriterProxy)new TCPWriterProxy(), defs, 50, 2, 0.5f, 5L, TimeUnit.MINUTES);
        this.links = 0;
    }

    @Override
    public String getLocator() throws GRS2WriterException {
        return this.writer.getLocator().toString();
    }

    @Override
    public synchronized boolean add(T input) throws InvalidRecordException, WrapperAlreadyDisposedException {
        GenericRecord gr = new GenericRecord();
        String bindElement = null;
        if (input instanceof String) {
            bindElement = (String)input;
        } else {
            try {
                bindElement = Bindings.toXml(input);
            }
            catch (JAXBException e) {
                throw new InvalidRecordException((Throwable)e);
            }
        }
        gr.setFields((Field[])new StringField[]{new StringField(bindElement)});
        try {
            return this.writer.put((Record)gr, 5L, TimeUnit.MINUTES);
        }
        catch (Exception e) {
            logger.trace("the writer is already disposed (trying to write something when it is closed)");
            throw new WrapperAlreadyDisposedException((Throwable)e);
        }
    }

    @Override
    public void close() {
        try {
            if (!this.isClosed()) {
                this.writer.close();
            }
        }
        catch (Exception e) {
            logger.warn("error closing the writer", (Throwable)e);
        }
    }

    @Override
    public boolean isClosed() {
        return this.writer.getStatus() == IBuffer.Status.Dispose || this.writer.getStatus() == IBuffer.Status.Close;
    }

    static {
        ArrayList<PortRange> ports = new ArrayList<PortRange>();
        ports.add(new PortRange(3050, 3100));
        String hostname = "";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TCPConnectionManager.Init((TCPConnectionManagerConfig)new TCPConnectionManagerConfig(hostname, ports, true));
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPConnectionHandler());
        TCPConnectionManager.RegisterEntry((ITCPConnectionManagerEntry)new TCPStoreConnectionHandler());
        logger = LoggerFactory.getLogger(ResultWrapper.class);
    }
}

