/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.plugin.fwk.writers.rswrapper;

import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.gcube.data.spd.model.exceptions.InvalidRecordException;
import org.gcube.data.spd.model.exceptions.WrapperAlreadyDisposedException;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.AbstractWrapper;

public class LocalWrapper<T>
extends AbstractWrapper<T> {
    private String locator = UUID.randomUUID().toString();
    private ArrayBlockingQueue<T> queue;
    private boolean closed = false;
    private boolean forceOpen = false;
    private int timeoutTimeInMinutes = 1;

    public LocalWrapper() {
        this.queue = new ArrayBlockingQueue(100);
    }

    public LocalWrapper(int queueSize) {
        this.queue = new ArrayBlockingQueue(queueSize);
    }

    @Override
    public String getLocator() throws Exception {
        return this.locator;
    }

    @Override
    public synchronized boolean add(T input) throws InvalidRecordException, WrapperAlreadyDisposedException {
        if (this.closed) {
            new WrapperAlreadyDisposedException("the local wrapper has been disposed");
        }
        try {
            return this.queue.offer(input, this.timeoutTimeInMinutes, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.close();
            this.queue = null;
            throw new WrapperAlreadyDisposedException("the local wrapper has been disposed");
        }
    }

    @Override
    public void close() {
        if (!this.isForceOpen()) {
            this.closed = true;
        } else {
            this.logger.warn("cannot close the Wrapper, forceOpen enabled");
        }
    }

    public ArrayBlockingQueue<T> getQueue() {
        return this.queue;
    }

    public void setTimeoutTimeInMinutes(int timeoutTimeInMinutes) {
        this.timeoutTimeInMinutes = timeoutTimeInMinutes;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public boolean isForceOpen() {
        return this.forceOpen;
    }

    public void forceOpen() {
        this.forceOpen = true;
    }

    public void disableForceOpen() {
        this.forceOpen = false;
    }

    public void disableForceOpenAndClose() {
        this.forceOpen = false;
        this.close();
    }
}

