/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.plugin.fwk;

import java.util.Collections;
import java.util.Set;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.data.spd.model.Properties;
import org.gcube.data.spd.model.Property;
import org.gcube.data.spd.model.PropertySupport;
import org.gcube.data.spd.model.ResultItem;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.plugin.fwk.SearchTypes;
import org.gcube.data.spd.plugin.fwk.Searchable;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.util.RepositoryInfo;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public abstract class AbstractPlugin
implements PropertySupport,
Searchable<ResultItem> {
    private boolean initialized = false;
    private boolean useCache = false;

    public void initialize(ServiceEndpoint resource) throws Exception {
        this.initialized = true;
    }

    public void update(ServiceEndpoint resource) throws Exception {
    }

    public void shutdown() throws Exception {
    }

    public ClassificationCapability getClassificationInterface() {
        return null;
    }

    public NamesMappingCapability getNamesMappingInterface() {
        return null;
    }

    public OccurrencesCapability getOccurrencesInterface() {
        return null;
    }

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    public Set<Capabilities> getSupportedCapabilities() {
        return Collections.emptySet();
    }

    public Set<SearchTypes> getSupportedSearch() {
        return Collections.emptySet();
    }

    public abstract RepositoryInfo getRepositoryInfo();

    @Override
    public Class<ResultItem> getHandledClass() {
        return ResultItem.class;
    }

    @Override
    public abstract void searchByCommonName(String var1, ObjectWriter<ResultItem> var2, Property ... var3);

    @Override
    public abstract void searchByScientificName(String var1, ObjectWriter<ResultItem> var2, Property ... var3);

    public abstract String getRepositoryName();

    public abstract String getDescription();

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isRemote() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        AbstractPlugin ap = (AbstractPlugin)obj;
        if (ap.getRepositoryName() == null || ap.getRepositoryName().equals("")) {
            return false;
        }
        return ap.getRepositoryName().equals(this.getRepositoryName());
    }

    public int hashCode() {
        return this.getRepositoryName().hashCode();
    }
}

