package org.gcube.data.spd.plugin.fwk.writers.rswrapper;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.exceptions.InvalidRecordException;
import org.gcube.data.spd.plugin.fwk.exceptions.WrapperAlreadyDisposedException;

import edu.emory.mathcs.backport.java.util.Arrays;



public abstract class AbstractWrapper<T> {

	GCUBELog logger= new GCUBELog(AbstractWrapper.class);
	
	protected int links; 
	
	public abstract String getLocator() throws Exception;
	
	public abstract boolean add(T result) throws InvalidRecordException, WrapperAlreadyDisposedException;
		
	public  abstract void close();
	
	public synchronized void unregister(){
		links--;
		if (links<=0){
			if (!this.isClosed())
					this.close();
			else throw new IllegalStateException("wrapper already closed");
		}
	}
	
	
	
	public synchronized void register(){
		this.links++;
		logger.trace("local wrapper registering "+(links)+" in ----- "+Arrays.toString(new Throwable().getStackTrace()));
	}
	
	public abstract boolean isClosed();
	
}
