package org.gcube.data.spd.plugin.fwk.writers;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.AbstractWrapper;



public abstract class AbstractWriter<T> implements ObjectWriter<T>{
		
	private GCUBELog logger= new GCUBELog(AbstractWriter.class);
	
	private boolean closed;
	
	private int links =0;
	
	private AbstractWrapper<T> wrapper;
	
	protected int wrote;
	
	protected AbstractWriter(AbstractWrapper<T> wrapper) {
		logger.trace("writer created -----   ");
		this.wrapper = wrapper;
		this.wrapper.register();
	}

	protected AbstractWrapper<T> getWrapper() {
		return wrapper;
	}
	
	public synchronized void register(){
		links++;
	}
	
	public synchronized void register(int links){
		this.links+=links;
	}
	
	public synchronized void close() {
		links--;
		if (links<=0){
			logger.trace("wrote "+wrote+" elements");
			if (!closed){
				this.wrapper.unregister();
				closed=true;
			}  else throw new IllegalStateException("writer already closed");
		}
	}
	
}
