package org.gcube.data.spd.plugin.fwk.writers;


import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.exceptions.InvalidRecordException;
import org.gcube.data.spd.plugin.fwk.exceptions.StreamException;
import org.gcube.data.spd.plugin.fwk.exceptions.WrapperAlreadyDisposedException;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.AbstractWrapper;


public class Writer<F> extends AbstractWriter<F>{

	private GCUBELog logger= new GCUBELog(Writer.class);
		
	private WriterManager<F> manager = new DefaultWriter();
	
		
	public Writer(AbstractWrapper<F> wrapper) {
		super(wrapper);
	}
	
	public Writer(AbstractWrapper<F> wrapper, WriterManager<F> manager) {
		super(wrapper);
		this.manager = manager;
	}

	@Override
	@Deprecated
	public synchronized boolean put(F t){
		if(this.getWrapper().isClosed()) return false;
		if (manager.filter(t)){
			try{
				getWrapper().add(manager.enrich(t));
			}catch (InvalidRecordException e) {
				logger.warn("error putting a result in the Writer",e);
			}catch (WrapperAlreadyDisposedException e) {
				logger.warn("wrapper already disposed",e);
				return false;
			}
		} else logger.debug("a result has been filtered");
		return true;
	}

	
	public class DefaultWriter extends WriterManager<F>{}


	@Override
	@Deprecated
	public synchronized boolean put(StreamException error) {
		return true;
	}

	@Override
	public synchronized boolean write(F t) {
		if(this.getWrapper().isClosed()) return false;
		if (manager.filter(t)){
			try{
				getWrapper().add(manager.enrich(t));
			}catch (InvalidRecordException e) {
				logger.warn("error putting a result in the Writer",e);
				return false;
			}catch (WrapperAlreadyDisposedException e) {
				logger.warn("wrapper already disposed",e);
				return false;
			}
		} else{
			logger.debug("a result has been filtered");
			return false;
		}
		return true;
	}

	@Override
	public synchronized boolean write(StreamException error) {
		return true;
	}

	@Override
	public boolean isAlive() {
		return !getWrapper().isClosed();
	}
	
	

}
