package org.gcube.data.spd.plugin.fwk.capabilities;

import java.util.Iterator;

import org.gcube.data.spd.plugin.fwk.PropertySupport;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.Searchable;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public abstract class OccurrencesCapability implements PropertySupport, Searchable<OccurrencePoint>{

	/**
	 * retrieves all occurrences for the given ids
	 * 
	 * @param writer the stream where the elements must be wrote
	 * @param keys a list of products keys
	 * @throws Exception
	 */
	public abstract void getOccurrencesByProductKeys(ObjectWriter<OccurrencePoint> writer, Iterator<String> keys); 
	
	/**
	 * retrieves all occurrences for the given ids
	 * 
	 * @param writer the stream where the elements must be wrote
	 * @param ids a list of occurrence ids
	 * @throws Exception
	 */
	public abstract void getOccurrencesByIds(ObjectWriter<OccurrencePoint> writer, Iterator<String> ids);

	@Override
	public Class<OccurrencePoint> getHandledClass() {
		return OccurrencePoint.class;
	} 
	
	
	
}
