package org.gcube.data.spd.plugin.fwk.writers.rswrapper;

import org.gcube.data.spd.plugin.fwk.exceptions.InvalidRecordException;
import org.gcube.data.spd.plugin.fwk.exceptions.WrapperAlreadyDisposedException;



public abstract class AbstractWrapper<T> {

	public abstract String getLocator() throws Exception;
	
	public abstract boolean add(T result) throws InvalidRecordException, WrapperAlreadyDisposedException;
		
	public  abstract void close();
	
	public abstract void unregister();
	
	public abstract void register();
	
	public abstract boolean isClosed();
	
}
