package org.gcube.data.spd.plugin.fwk.writers;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.model.ResultElement;
import org.gcube.data.spd.plugin.fwk.util.Util;

public abstract class ResultElementWriterManager<T extends ResultElement> extends WriterManager<T> {

	private static GCUBELog logger = new GCUBELog(ResultElementWriterManager.class);
	
	protected String provider;

	public ResultElementWriterManager(String provider) {
		super();
		this.provider = provider;
	}

	@Override
	public T enrich(T obj) {
		try{
			return _enrich(Util.<T>copy(obj));
		}catch (Exception e) {
			logger.error("error enriching object",e);
			return null;
		}
	}
	
	protected abstract T _enrich(T obj);
	
	
	
	
}
