/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.plugin.fwk.writers.rswrapper;

import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.gcube.data.spd.plugin.fwk.exceptions.InvalidRecordException;
import org.gcube.data.spd.plugin.fwk.exceptions.WrapperAlreadyDisposedException;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.AbstractWrapper;

public class LocalWrapper<T>
extends AbstractWrapper<T> {
    private String locator = UUID.randomUUID().toString();
    private ArrayBlockingQueue<T> queue;
    private boolean closed = false;
    private boolean forceOpen = false;
    private int links;
    private int timeoutTimeInMinutes = 1;

    public LocalWrapper() {
        this.queue = new ArrayBlockingQueue(100);
    }

    public LocalWrapper(int queueSize) {
        this.queue = new ArrayBlockingQueue(queueSize);
    }

    @Override
    public String getLocator() throws Exception {
        return this.locator;
    }

    @Override
    public synchronized boolean add(T input) throws InvalidRecordException, WrapperAlreadyDisposedException {
        if (this.closed) {
            new WrapperAlreadyDisposedException("the local wrapper has been disposed");
        }
        try {
            return this.queue.offer(input, this.timeoutTimeInMinutes, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            this.close();
            this.queue = null;
            throw new WrapperAlreadyDisposedException("the local wrapper has been disposed");
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    public ArrayBlockingQueue<T> getQueue() {
        return this.queue;
    }

    public void setTimeoutTimeInMinutes(int timeoutTimeInMinutes) {
        this.timeoutTimeInMinutes = timeoutTimeInMinutes;
    }

    @Override
    public synchronized void unregister() {
        if (this.links > 1) {
            --this.links;
        } else {
            this.links = 0;
            if (!this.forceOpen) {
                this.close();
            }
        }
    }

    @Override
    public synchronized void register() {
        ++this.links;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public boolean isForceOpen() {
        return this.forceOpen;
    }

    public void forceOpen() {
        this.forceOpen = true;
    }
}

