package org.gcube.data.spd.plugin.fwk.writers;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.AbstractWrapper;

public abstract class AbstractWriter<T> implements ObjectWriter<T>{
		
	private GCUBELog logger= new GCUBELog(AbstractWriter.class);
	
	private boolean closed;
	
	private int links =0;
	
	private AbstractWrapper<T> wrapper;
	
	protected AbstractWriter(AbstractWrapper<T> wrapper) {
		this.wrapper = wrapper;
	}

	protected AbstractWrapper<T> getWrapper() {
		return wrapper;
	}
	
	public synchronized void register(){
		if (links==0) getWrapper().register();
		links++;
	}
	
	public synchronized void register(int links){
		if (this.links==0) getWrapper().register();
		this.links+=links;
	}
	
	public synchronized void close() {
		logger.trace("closing writer");
		try {
			if (links>1)
				links--;
			else if (!closed){
				this.wrapper.unregister();
				closed=true;
			}
		} catch (Exception e) {
			logger.error("error closing writer",e);
		}
	}
	
	
}
