/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.plugin.fwk.writers.rswrapper;

import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.AbstractWrapper;

public class LocalWrapper<T>
extends AbstractWrapper<T> {
    private String locator = UUID.randomUUID().toString();
    private ArrayBlockingQueue<T> queue;
    private boolean closed = false;
    private int links;
    private int timeoutTimeInMinutes = 1;

    public LocalWrapper() {
        this.queue = new ArrayBlockingQueue(100);
    }

    public LocalWrapper(int queueSize) {
        this.queue = new ArrayBlockingQueue(queueSize);
    }

    @Override
    public String getLocator() throws Exception {
        return this.locator;
    }

    @Override
    public synchronized boolean add(T input) throws Exception {
        return this.queue.offer(input, this.timeoutTimeInMinutes, TimeUnit.MINUTES);
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
    }

    public ArrayBlockingQueue<T> getQueue() {
        return this.queue;
    }

    public void setTimeoutTimeInMinutes(int timeoutTimeInMinutes) {
        this.timeoutTimeInMinutes = timeoutTimeInMinutes;
    }

    @Override
    public synchronized void unregister() throws Exception {
        if (this.links > 1) {
            --this.links;
        } else {
            this.links = 0;
            this.close();
        }
    }

    @Override
    public synchronized void register() {
        ++this.links;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

