/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.plugin.fwk.writers;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.AbstractWrapper;

public abstract class AbstractWriter<T>
implements ObjectWriter<T> {
    private GCUBELog logger = new GCUBELog(AbstractWriter.class);
    private boolean closed;
    private int links = 0;
    private AbstractWrapper<T> wrapper;

    protected AbstractWriter(AbstractWrapper<T> wrapper) {
        this.wrapper = wrapper;
    }

    protected AbstractWrapper<T> getWrapper() {
        return this.wrapper;
    }

    public synchronized void register() {
        if (this.links == 0) {
            this.getWrapper().register();
        }
        ++this.links;
    }

    public synchronized void register(int links) {
        if (this.links == 0) {
            this.getWrapper().register();
        }
        this.links += links;
    }

    @Override
    public synchronized void close() {
        this.logger.trace((Object)"closing writer");
        try {
            if (this.links > 1) {
                --this.links;
            } else if (!this.closed) {
                this.wrapper.unregister();
                this.closed = true;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"error closing writer", (Throwable)e);
        }
    }
}

