/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.plugin.fwk.readers;

import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.LocalWrapper;

public class LocalReader<T>
implements Iterator<T> {
    private GCUBELog logger = new GCUBELog(LocalReader.class);
    private ArrayBlockingQueue<T> queue;
    private T element = null;
    private int timeoutInSeconds = 30;
    LocalWrapper<T> wrapper;

    public LocalReader(LocalWrapper<T> wrapper) {
        this.queue = wrapper.getQueue();
        this.wrapper = wrapper;
    }

    @Override
    public boolean hasNext() {
        if (this.queue == null) {
            return false;
        }
        try {
            this.element = null;
            if (!this.wrapper.isClosed()) {
                while (!this.wrapper.isClosed() && this.element == null) {
                    this.element = this.queue.poll(this.timeoutInSeconds, TimeUnit.SECONDS);
                }
            }
            if (this.element == null) {
                this.element = this.queue.poll();
            }
        }
        catch (InterruptedException e) {
            this.logger.trace((Object)"the queue is empty", (Throwable)e);
        }
        return this.element != null;
    }

    public void setTimeoutInSeconds(int timeoutInSeconds) {
        this.timeoutInSeconds = timeoutInSeconds;
    }

    @Override
    public T next() {
        this.logger.trace((Object)("reading element " + this.element));
        return this.element;
    }

    @Override
    public void remove() {
    }
}

