package org.gcube.data.spd.plugin.fwk.readers;

import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.writers.rswrapper.LocalWrapper;


public class LocalReader<T> implements Iterator<T>{

	private GCUBELog logger = new GCUBELog(LocalReader.class);
	
	private ArrayBlockingQueue<T> queue;
	
	private T element = null;
	
	private int timeoutInSeconds= 30; 
	
	LocalWrapper<T> wrapper ;
	
	public LocalReader(LocalWrapper<T> wrapper) {
		queue = wrapper.getQueue();
		this.wrapper = wrapper;
		
	}

	
	
	@Override
	public boolean hasNext() {
		if (queue==null)	return false;
		else{
			try {
				element=null;
				if (!this.wrapper.isClosed()){
					while (!this.wrapper.isClosed() && element==null )
						element= queue.poll(timeoutInSeconds, TimeUnit.SECONDS);
				}
				if (element ==null) element=queue.poll();
			} catch (InterruptedException e) {
				logger.trace("the queue is empty",e);
			}
			return element!=null;
		}
	}

	
	
	public void setTimeoutInSeconds(int timeoutInSeconds) {
		this.timeoutInSeconds = timeoutInSeconds;
	}



	@Override
	public T next() {
		logger.trace("reading element "+element);
		return element;
	}

	@Override
	public void remove() {}

	
	
}
