package org.gcube.data.spd.plugin.fwk.model.binding;

import java.io.StringReader;
import java.io.StringWriter;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.plugin.fwk.model.OccurrencePoint;
import org.gcube.data.spd.plugin.fwk.model.PointInfo;
import org.gcube.data.spd.plugin.fwk.model.ResultItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;



public class Bindings {

	private static GCUBELog logger = new GCUBELog(Bindings.class);
	
	private  static JAXBContext context ;
	
	static{
		try {
			context = JAXBContext.newInstance(OccurrencePoint.class, TaxonomyItem.class, ResultItem.class, PointInfo.class);
		} catch (JAXBException e) {
			logger.error("error preparing the binding ",e);
		}
	}
		
	public static <T> String toXml(T obj) throws Exception{
		StringWriter sw = new StringWriter();
		context.createMarshaller().marshal(obj, sw);
		return sw.toString();
	}
	
	@SuppressWarnings("unchecked")
	public static <T> T fromXml(String payload) throws Exception{
		return (T) context.createUnmarshaller().unmarshal(new StringReader(payload));
	}
	
}
