package org.gcube.data.spd.model.service.types;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;

import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class MapAdapter extends XmlAdapter<String, Map<Object, Object>>{

	private HexBinaryAdapter hexAdapter = new HexBinaryAdapter();
	
	@Override
	public String marshal(Map<Object, Object> oi) throws Exception {
		ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(oi);
        oos.close();
        byte[] serializedBytes = baos.toByteArray();
        return hexAdapter.marshal(serializedBytes);
	}

	@SuppressWarnings("unchecked")
	@Override
	public Map<Object, Object> unmarshal(String oi) throws Exception {
		byte[] serializedBytes = hexAdapter.unmarshal(oi);
        ByteArrayInputStream bais = new ByteArrayInputStream(serializedBytes);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Map<Object, Object> result = (Map<Object, Object>) ois.readObject();
        return result;
	}

}
