package org.gcube.data.spd.model.service;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.data.spd.model.service.exceptions.QueryNotValidException;
import org.gcube.data.spd.model.service.exceptions.UnsupportedCapabilityException;
import org.gcube.data.spd.model.service.exceptions.UnsupportedPluginException;
import org.gcube.data.spd.model.service.types.PluginDescriptions;

@WebService(name=Constants.manager_portType,targetNamespace=Constants.manager_target_namespace)
public interface ManagerStubs {
	
	@SOAPBinding(parameterStyle=ParameterStyle.BARE)
	String search(String query) throws QueryNotValidException, UnsupportedPluginException, UnsupportedCapabilityException;
	
	@SOAPBinding(parameterStyle=ParameterStyle.BARE)
	PluginDescriptions getSupportedPlugins();
	
}
