package org.gcube.data.spd.model.service;

import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.jws.soap.SOAPBinding.ParameterStyle;

import org.gcube.data.spd.model.service.exceptions.InvalidIdentifierException;
import org.gcube.data.spd.model.service.exceptions.UnsupportedCapabilityException;
import org.gcube.data.spd.model.service.exceptions.UnsupportedPluginException;

@WebService(name=Constants.classification_portType,targetNamespace=Constants.classification_target_namespace)
@SOAPBinding(parameterStyle=ParameterStyle.BARE)
public interface ClassificationStubs {

	@SOAPBinding(parameterStyle=ParameterStyle.BARE)	
	public String retrieveTaxonChildrenByTaxonId(String id) throws UnsupportedPluginException,UnsupportedCapabilityException, InvalidIdentifierException;
	
	@SOAPBinding(parameterStyle=ParameterStyle.BARE)	
	public String retrieveChildrenTreeById(String id) throws UnsupportedPluginException,UnsupportedCapabilityException, InvalidIdentifierException; 
	
	@SOAPBinding(parameterStyle=ParameterStyle.BARE)	
	public String retrieveSynonymsById(String id) throws UnsupportedPluginException,UnsupportedCapabilityException, InvalidIdentifierException; 
	
	@SOAPBinding(parameterStyle=ParameterStyle.BARE)	
	public String getTaxaByIds(String ids); 
}
