package org.gcube.data.spd.stubs.types;

import java.util.List;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class RepositoryInfo {

	@XmlElement
	private String referencePageUrl;
	
	@XmlElement
	private String logoUrl;
	
	@XmlElement
	private String description;
	
	@XmlElement(name="properties")
	private List<PluginProperty> properties;

	public String getReferencePageUrl() {
		return referencePageUrl;
	}

	public String getLogoUrl() {
		return logoUrl;
	}

	public String getDescription() {
		return description;
	}

	public List<PluginProperty> getProperties() {
		return properties;
	}

	@Override
	public String toString() {
		return "RepositoryInfo [referencePageUrl=" + referencePageUrl
				+ ", logoUrl=" + logoUrl + ", description=" + description
				+ ", properties=" + properties + "]";
	}

	
}
