package org.gcube.data.spd.client.proxies;

import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.stubs.StatusResponse;
import org.gcube.data.streams.Stream;

public interface Executor {

	public String createDwCAByChildren(String taxonKey) throws Exception;
	
	public String getResultLink(String jobId) throws IdNotValidException, Exception ;
	
	public StatusResponse getStatus(String jobId) throws IdNotValidException, Exception ;
	
	public void removeJob(String jobId) throws IdNotValidException, Exception;
	
	public String createDwCAByIds(final Stream<String> ids) throws Exception;
	
	public String createCSV(final Stream<String> ids) throws Exception;
	
	public String createCSVforOM(final Stream<String> ids) throws Exception;
	public String createDarwincoreFromOccurrenceKeys(final Stream<String> ids) throws Exception;
	
}
