package org.gcube.data.spd.client.proxies;

import gr.uoa.di.madgik.grs.record.GenericRecord;
import java.net.URI;
import java.util.concurrent.TimeUnit;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.types.VOID;
import org.gcube.data.spd.client.ResultGenerator;
import org.gcube.data.spd.plugin.fwk.model.ResultElement;
import org.gcube.data.spd.stubs.ManagerPortType;
import org.gcube.data.spd.stubs.PluginDescription;
import org.gcube.data.spd.stubs.QueryNotValidFault;
import org.gcube.data.streams.Stream;


import static org.gcube.data.streams.dsl.Streams.*;
import static org.gcube.common.clients.exceptions.FaultDSL.*;

public class DefaultManager implements Manager {

	private final ProxyDelegate<ManagerPortType> delegate;
	
	private final ResultGenerator<ResultElement> resultElementGenerator = new ResultGenerator<ResultElement>();
	
	public DefaultManager(ProxyDelegate<ManagerPortType> config){
		this.delegate = config;
	}
	
		
	@Override
	public Stream<ResultElement> search(final String query) throws QueryNotValidFault{
		
		Call<ManagerPortType, URI> call = new Call<ManagerPortType, URI>() {
			@Override
			public URI call(ManagerPortType managerPT) throws Exception {
				return new URI(managerPT.search(query));
			}
		};
		try {
			return pipe(convert(delegate.make(call)).of(GenericRecord.class)
					.withTimeout(delegate.config().property("streamTimeoutInMinutes", Integer.class), TimeUnit.MINUTES)).through(resultElementGenerator);
		}catch(Exception e) {
			throw again(e).as(QueryNotValidFault.class);
		}
	}

	@Override
	public PluginDescription[] getPluginsDescription() {
		
		Call<ManagerPortType, PluginDescription[]> call = new Call<ManagerPortType, PluginDescription[]>() {
			@Override
			public PluginDescription[] call(ManagerPortType managerPT) throws Exception {
				return managerPT.getSupportedPlugins(new VOID()).getDescriptors();
			}
		};
		
		try {
			return delegate.make(call);
		}catch(Exception e) {
			throw again(e).asServiceException();
		}
	}
		
}
