package org.gcube.data.spd.client.plugins;

import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.client.proxies.DefaultManager;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.plugin.fwk.exceptions.InvalidQueryException;
import org.gcube.data.spd.stubs.ManagerPortType;
import org.gcube.data.spd.stubs.QueryNotValidFault;
import org.gcube.data.spd.stubs.service.ManagerServiceAddressingLocator;

public class ManagerPlugin extends AbstractPlugin<ManagerPortType, Manager> {

	GCUBELog logger = new GCUBELog(ManagerPlugin.class);
	
	public ManagerPlugin() {
		super("gcube/data/speciesproductsdiscovery/manager");
	}

	@Override
	public Exception convert(Exception fault, ProxyConfig<?, ?> proxy) {
		if (fault instanceof QueryNotValidFault)
			return new InvalidQueryException(fault.getMessage());
		return fault;
	}

	@Override
	public Manager newProxy(ProxyDelegate<ManagerPortType> proxy) {
		return new DefaultManager(proxy);
	}

	@Override
	public ManagerPortType resolve(EndpointReferenceType address,ProxyConfig<?,?> config) throws Exception {
		return new ManagerServiceAddressingLocator().getManagerPortTypePort(address);
	}

}
