package org.gcube.data.spd.client.plugins;

import org.gcube.common.clients.config.Property;
import org.gcube.common.clients.gcore.builders.StatelessBuilder;
import org.gcube.common.clients.gcore.builders.StatelessBuilderImpl;
import org.gcube.common.clients.gcore.plugins.Plugin;
import org.gcube.data.spd.client.Constants;
import org.gcube.data.spd.client.proxies.Classification;
import org.gcube.data.spd.client.proxies.Executor;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.client.proxies.Occurrences;
import org.gcube.data.spd.stubs.ClassificationPortType;
import org.gcube.data.spd.stubs.ExecutorPortType;
import org.gcube.data.spd.stubs.ManagerPortType;
import org.gcube.data.spd.stubs.OccurrencesPortType;


public abstract class AbstractPlugin<S,P> implements Plugin<S,P> {

	private static final ManagerPlugin manager_plugin = new ManagerPlugin();
	private static final OccurrencesPlugin occurrences_plugin = new OccurrencesPlugin();
	private static final ClassificationPlugin classification_plugin = new ClassificationPlugin();
	private static final ExecutorPlugin executor_plugin = new ExecutorPlugin();
	
	
	public static StatelessBuilder<Manager> manager() {
		return new StatelessBuilderImpl<ManagerPortType,Manager>(manager_plugin, new Property<Integer>("streamTimeoutInMinutes", 10));
	}
	
	public static StatelessBuilder<Occurrences> occurrences() {
		return new StatelessBuilderImpl<OccurrencesPortType,Occurrences>(occurrences_plugin);
	}
	
	public static StatelessBuilder<Classification> classification() {
		return new StatelessBuilderImpl<ClassificationPortType,Classification>(classification_plugin);
	}
	
	public static StatelessBuilder<Executor> executor() {
		return new StatelessBuilderImpl<ExecutorPortType,Executor>(executor_plugin);
	}
	
	public final String name;
	
	public AbstractPlugin(String name) {
		this.name=name;
	}
	
	@Override
	public String serviceClass() {
		return Constants.SERVICE_CLASS;
	}
	
	@Override
	public String serviceName() {
		return Constants.SERVICE_NAME;
	}
	
	@Override
	public String namespace() {
		return Constants.NAMESPACE;
	}
	
	@Override
	public String name() {
		return name;
	}
	
}