/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.client.formats;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Classification;
import org.gcube.data.spd.plugin.fwk.model.CommonName;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.streams.Stream;
import org.gcube.data.streams.dsl.Streams;

public class MapDwCA {
    static GCUBELog logger = new GCUBELog(MapDwCA.class);
    private BufferedWriter vernacularFile;
    private BufferedWriter file;
    private File tempFolder;
    private List<File> fileList = new ArrayList<File>();
    private String archiveZip = "archive-tax.zip";
    private HashSet<String> inserted;

    public synchronized File createDwCA(Stream<String> taxonIds) throws Exception {
        this.createMetaXml();
        this.createMetadata();
        this.createHeaders();
        this.createTaxaTxt(taxonIds);
        this.getAllFiles(this.tempFolder);
        return this.writeZipFile(this.tempFolder);
    }

    private void createMetaXml() {
        try {
            String line;
            BufferedWriter bw = null;
            BufferedReader br = null;
            this.tempFolder = File.createTempFile("DwCA-folder", "");
            this.tempFolder.delete();
            this.tempFolder.mkdir();
            File output = new File(this.tempFolder + "/meta.xml");
            bw = new BufferedWriter(new FileWriter(output));
            br = new BufferedReader(new InputStreamReader(MapDwCA.class.getResourceAsStream("/org/gcube/data/spd/dwca/meta.xml")));
            while ((line = br.readLine()) != null) {
                bw.write(line);
                bw.write(10);
            }
            bw.close();
            br.close();
        }
        catch (IOException e) {
            logger.error((Object)"IO Error", (Throwable)e);
        }
    }

    private void createHeaders() {
        try {
            BufferedWriter file = new BufferedWriter(new FileWriter(this.tempFolder + "/" + "taxa.txt", true));
            this.vernacularFile = new BufferedWriter(new FileWriter(this.tempFolder + "/" + "VernacularName.txt", true));
            this.inserted = new HashSet();
            file.write("taxonID\t");
            file.write("acceptedNameUsageID\t");
            file.write("parentNameUsageID\t");
            file.write("scientificName\t");
            file.write("scientificNameAuthorship\t");
            file.write("kingdom\t");
            file.write("phylum\t");
            file.write("class\t");
            file.write("order\t");
            file.write("family\t");
            file.write("genus\t");
            file.write("subgenus\t");
            file.write("specificEpithet\t");
            file.write("infraspecificEpithet\t");
            file.write("verbatimTaxonRank\t");
            file.write("taxonRank\t");
            file.write("taxonomicStatus\t");
            file.write("modified\t");
            file.write("bibliographicCitation\t");
            file.write("taxonRemarks\n");
            file.close();
            this.vernacularFile.write("taxonID\t");
            this.vernacularFile.write("vernacularName\t");
            this.vernacularFile.write("language\t");
            this.vernacularFile.write("locality\n");
            this.vernacularFile.close();
        }
        catch (IOException e) {
            logger.error((Object)"IO Error", (Throwable)e);
        }
    }

    public void createTaxaTxt(Stream<String> taxonIds) {
        Stream<TaxonomyItem> taxonomyItems = ((Classification)AbstractPlugin.classification().build()).getTaxonByIds((Stream<String>)Streams.convert(taxonIds));
        while (taxonomyItems.hasNext()) {
            TaxonomyItem item = (TaxonomyItem)taxonomyItems.next();
            logger.trace((Object)item.toString());
            this.writeLine(item);
        }
    }

    private void writeLine(TaxonomyItem taxonomyItem) {
        if (!this.inserted.contains(taxonomyItem.getId())) {
            try {
                logger.trace((Object)taxonomyItem.getScientificName());
                String[] name = taxonomyItem.getScientificName().split(" ");
                TaxonomyItem tax = taxonomyItem.getParent();
                Hashtable<String, String> hashTaxa = new Hashtable<String, String>();
                if (tax != null) {
                    this.getTax(tax, hashTaxa);
                }
                this.inserted.add(taxonomyItem.getId());
                this.file = new BufferedWriter(new FileWriter(this.tempFolder + "/" + "taxa.txt", true));
                this.file.write(taxonomyItem.getId());
                this.file.write("\t");
                if (taxonomyItem.getStatus().getRefId() != null) {
                    String id = taxonomyItem.getStatus().getRefId();
                    this.file.write(id);
                    Stream<TaxonomyItem> items = ((Classification)AbstractPlugin.classification().build()).getTaxonByIds((Stream<String>)Streams.convert(Collections.singletonList(id)));
                    if (items.hasNext()) {
                        this.writeLine((TaxonomyItem)items.next());
                    }
                }
                this.file.write("\t");
                if (tax != null) {
                    this.file.write(tax.getId());
                }
                this.file.write("\t");
                if (taxonomyItem.getCitation() != null) {
                    this.file.write(String.valueOf(taxonomyItem.getScientificName()) + " " + taxonomyItem.getCitation());
                } else {
                    this.file.write(taxonomyItem.getScientificName());
                }
                this.file.write("\t");
                if (taxonomyItem.getCitation() != null) {
                    this.file.write(taxonomyItem.getCitation());
                }
                this.file.write("\t");
                String kingdom = hashTaxa.get("kingdom");
                if (kingdom != null) {
                    this.file.write(kingdom);
                }
                this.file.write("\t");
                String phylum = hashTaxa.get("phylum");
                if (phylum != null) {
                    this.file.write(phylum);
                }
                this.file.write("\t");
                String claz = hashTaxa.get("class");
                if (claz != null) {
                    this.file.write(claz);
                }
                this.file.write("\t");
                String order = hashTaxa.get("order");
                if (order != null) {
                    this.file.write(order);
                }
                this.file.write("\t");
                String family = hashTaxa.get("family");
                if (family != null) {
                    this.file.write(family);
                }
                this.file.write("\t");
                String genus = hashTaxa.get("genus");
                if (genus != null) {
                    this.file.write(genus);
                }
                this.file.write("\t");
                String subgenus = hashTaxa.get("subgenus");
                if (subgenus != null) {
                    this.file.write(subgenus);
                }
                this.file.write("\t");
                if (name.length > 1) {
                    this.file.write(name[1]);
                }
                this.file.write("\t");
                if (name.length > 2) {
                    this.file.write(name[name.length - 1]);
                }
                this.file.write("\t");
                if (name.length > 2) {
                    this.file.write(name[name.length - 2]);
                }
                this.file.write("\t");
                if (taxonomyItem.getRank() != null) {
                    this.file.write(taxonomyItem.getRank().toLowerCase());
                }
                this.file.write("\t");
                this.file.write(taxonomyItem.getStatus().getStatus().toString().toLowerCase());
                this.file.write("\t");
                if (taxonomyItem.getModified() != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    Date date = taxonomyItem.getModified().getTime();
                    String s = sdf.format(date);
                    this.file.write(s);
                }
                this.file.write("\t");
                if (taxonomyItem.getCitation() != null) {
                    this.file.write(taxonomyItem.getCitation());
                }
                this.file.write("\t");
                if (taxonomyItem.getStatus().getStatusAsString() != null) {
                    this.file.write(taxonomyItem.getStatus().getStatusAsString());
                }
                this.file.write("\n");
                if (taxonomyItem.getCommonNames() != null) {
                    this.createVernacularTxt(taxonomyItem.getId(), taxonomyItem.getCommonNames());
                }
                this.file.close();
            }
            catch (IOException e) {
                logger.error((Object)"IO Error", (Throwable)e);
            }
        }
    }

    private void createVernacularTxt(String id, List<CommonName> list) {
        try {
            this.vernacularFile = new BufferedWriter(new FileWriter(this.tempFolder + "/" + "VernacularName.txt", true));
            for (CommonName vernacular : list) {
                this.vernacularFile.write(id);
                this.vernacularFile.write("\t");
                this.vernacularFile.write(vernacular.getName());
                this.vernacularFile.write("\t");
                this.vernacularFile.write(vernacular.getLanguage());
                this.vernacularFile.write("\t");
                if (vernacular.getLocality() != null) {
                    this.vernacularFile.write(vernacular.getLocality());
                }
                this.vernacularFile.write("\n");
            }
            this.vernacularFile.close();
        }
        catch (IOException e) {
            logger.error((Object)"IO Error", (Throwable)e);
        }
    }

    private void getTax(TaxonomyItem tax, Hashtable<String, String> taxa) {
        taxa.put(tax.getRank().toLowerCase(), tax.getScientificName());
        this.writeLine(tax);
        if (tax.getParent() != null) {
            this.getTax(tax.getParent(), taxa);
        }
    }

    private void getAllFiles(File dir) {
        try {
            File[] files;
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.fileList.add(file);
                if (file.isDirectory()) {
                    logger.trace((Object)("directory:" + file.getCanonicalPath()));
                    this.getAllFiles(file);
                } else {
                    logger.trace((Object)("     file:" + file.getCanonicalPath()));
                }
                ++n2;
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
    }

    private File writeZipFile(File directoryToZip) throws Exception {
        File zipFile = new File(directoryToZip + "/" + this.archiveZip);
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zos = new ZipOutputStream(fos);
        for (File file : this.fileList) {
            if (file.isDirectory()) continue;
            this.addToZip(directoryToZip, file, zos);
        }
        zos.close();
        fos.close();
        return zipFile;
    }

    private void addToZip(File directoryToZip, File file, ZipOutputStream zos) throws FileNotFoundException, IOException {
        int length;
        FileInputStream fis = new FileInputStream(file);
        String zipFilePath = file.getCanonicalPath().substring(directoryToZip.getCanonicalPath().length() + 1, file.getCanonicalPath().length());
        logger.trace((Object)("Writing '" + zipFilePath + "' to zip file"));
        ZipEntry zipEntry = new ZipEntry(zipFilePath);
        zos.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zos.write(bytes, 0, length);
        }
        zos.closeEntry();
        fis.close();
    }

    public void createMetadata() throws IOException {
        String line;
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        File output = new File(this.tempFolder + "/eml.xml");
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(output));
        }
        catch (IOException e) {
            logger.error((Object)"IO Error", (Throwable)e);
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(MapDwCA.class.getResourceAsStream("/org/gcube/data/spd/dwca/eml.xml")));
        while ((line = br.readLine()) != null) {
            bw.write(line.replace("<pubDate></pubDate>", "<pubDate>" + format.format(now.getTime()) + "</pubDate>"));
            bw.write(10);
        }
        bw.close();
        br.close();
    }
}

