/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.search.query;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.gcube.data.spd.obisplugin.search.query.MappingUtils;
import org.gcube.data.spd.obisplugin.search.query.QueryCondition;
import org.gcube.data.spd.obisplugin.search.query.ResultType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryCount {
    private static Logger log = LoggerFactory.getLogger(QueryCount.class);
    @NonNull
    private String baseUri;
    List<QueryCondition> conditions = new ArrayList<QueryCondition>();
    @NonNull
    private ResultType resultType;

    public void setConditions(QueryCondition ... conditions) {
        this.conditions.addAll(Arrays.asList(conditions));
    }

    public List<QueryCondition> getConditions() {
        return this.conditions;
    }

    public int getCount() {
        try {
            Map<String, Object> mapping = MappingUtils.getObjectMapping(this.build());
            if (mapping.get("total") == null) {
                return 0;
            }
            return (Integer)mapping.get("total");
        }
        catch (Exception e) {
            log.error("error computing count, returning 0", (Throwable)e);
            return 0;
        }
    }

    private String build() {
        StringBuilder query = new StringBuilder(this.baseUri);
        if (!this.baseUri.endsWith("/")) {
            query.append("/");
        }
        query.append(this.resultType.getQueryEntry()).append("/");
        query.append("?size=0");
        if (this.conditions.size() > 0) {
            for (QueryCondition queryCond : this.conditions) {
                query.append("&").append(queryCond.getKey().replaceAll(" ", "%20")).append("=").append(queryCond.getValue().replaceAll(" ", "%20"));
            }
        }
        return query.toString();
    }

    @ConstructorProperties(value={"baseUri", "resultType"})
    public QueryCount(@NonNull String baseUri, @NonNull ResultType resultType) {
        if (baseUri == null) {
            throw new NullPointerException("baseUri");
        }
        if (resultType == null) {
            throw new NullPointerException("resultType");
        }
        this.baseUri = baseUri;
        this.resultType = resultType;
    }
}

