/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin.search;

public enum TaxonCategories implements Comparable<TaxonCategories>
{
    DOMAIN(1),
    KINGDOM(2),
    PHYLUM(3),
    DIVISION(4),
    SUBPHYLUM(5),
    SUBDIVISION(6),
    CLASS(7),
    SUBCLASS(8),
    SUPERORDER(9),
    ORDER(10),
    SUBORDER(11),
    FAMILY(12),
    SUBFAMILY(13),
    GENUS(14),
    SPECIES(15);

    private int order;

    private TaxonCategories(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public static TaxonCategories getByOrder(int position) {
        if (position < 1 || position > 15) {
            return null;
        }
        for (TaxonCategories taxon : TaxonCategories.values()) {
            if (taxon.order != position) continue;
            return taxon;
        }
        return null;
    }

    public static TaxonCategories getParent(TaxonCategories taxon) {
        if (taxon == null) {
            return null;
        }
        if (taxon.order <= 1) {
            return null;
        }
        int position = taxon.order;
        return TaxonCategories.getByOrder(--position);
    }

    public static TaxonCategories getTaxonCategory(String taxonRank) {
        if (taxonRank == null || taxonRank.isEmpty()) {
            return null;
        }
        String taxonR = taxonRank.toUpperCase();
        for (TaxonCategories taxon : TaxonCategories.values()) {
            if (taxon.name().compareTo(taxonR) != 0) continue;
            return taxon;
        }
        return null;
    }
}

