/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.model.BasisOfRecord;
import org.gcube.data.spd.model.CommonName;
import org.gcube.data.spd.model.Condition;
import org.gcube.data.spd.model.exceptions.IdNotValidException;
import org.gcube.data.spd.model.products.DataProvider;
import org.gcube.data.spd.model.products.DataSet;
import org.gcube.data.spd.model.products.OccurrencePoint;
import org.gcube.data.spd.model.products.Product;
import org.gcube.data.spd.model.products.ResultItem;
import org.gcube.data.spd.model.products.Taxon;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.spd.model.products.TaxonomyStatus;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.model.util.ElementProperty;
import org.gcube.data.spd.obisplugin.PluginSession;
import org.gcube.data.spd.obisplugin.Writer;
import org.gcube.data.spd.obisplugin.data.ProductKey;
import org.gcube.data.spd.obisplugin.data.SearchFilters;
import org.gcube.data.spd.obisplugin.util.Cache;
import org.gcube.data.spd.obisplugin.util.DateUtil;
import org.gcube.data.spd.obisplugin.util.Util;

public class ObisClient {
    protected static GCUBELog logger = new GCUBELog(ObisClient.class);
    protected static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("y-M-d");
    protected static final DateUtil DATE_UTIL = DateUtil.getInstance();
    protected static final SimpleDateFormat sdf = new SimpleDateFormat();
    public static final Cache<Integer, TaxonomyItem> taxonomyItemCache = new Cache(1000);
    static int counter = 0;
    static int sum = 0;
    protected static Set<Integer> found = new HashSet<Integer>();
    protected static Map<String, TaxonomyItem> foundTaxon = new HashMap<String, TaxonomyItem>();

    public static int getOccurrencesCount(PluginSession session, int taxonId, int datasetId, SearchFilters filters) throws SQLException {
        PreparedStatement statement = session.getOccurrencesCountPreparedStatement(taxonId, datasetId, filters);
        ResultSet rs = statement.executeQuery();
        if (!rs.next()) {
            return 0;
        }
        int occurrences = rs.getInt("occurrences");
        rs.close();
        return occurrences;
    }

    public static void getOccurrences(PluginSession session, String key, Writer<OccurrencePoint> writer) throws Exception {
        ProductKey productKey = ProductKey.deserialize(key);
        PreparedStatement statement = session.getOccurrencesPreparedStatement(productKey.getTaxonId(), productKey.getDataSetId(), productKey.getFilters());
        ResultSet rs = statement.executeQuery();
        String credits = ObisClient.generateCredits();
        boolean continueWrite = true;
        while (rs.next() && continueWrite) {
            OccurrencePoint occurrence = ObisClient.generateOccurrencePoint(rs, credits);
            continueWrite = writer.write(occurrence);
        }
        rs.close();
    }

    protected static OccurrencePoint generateOccurrencePoint(ResultSet rs, String credits) throws SQLException {
        String snPart;
        int scientificNameStartIndex;
        int authorStartIndex;
        Calendar dateCollected;
        int id = rs.getInt("id");
        OccurrencePoint occurrence = new OccurrencePoint(String.valueOf(id));
        occurrence.setDecimalLatitude(rs.getDouble("latitude"));
        occurrence.setDecimalLongitude(rs.getDouble("longitude"));
        Timestamp dateValue = rs.getTimestamp("datecollected");
        if (dateValue != null) {
            dateCollected = Calendar.getInstance();
            dateCollected.setTimeInMillis(dateValue.getTime());
            occurrence.setEventDate(dateCollected);
        } else {
            try {
                dateCollected = Calendar.getInstance();
                int year = Integer.parseInt(rs.getString("yearcollected"));
                int month = Integer.parseInt(rs.getString("monthcollected"));
                int date = Integer.parseInt(rs.getString("daycollected"));
                dateCollected.set(year, month, date);
                occurrence.setEventDate(dateCollected);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        String basisOfRecord = rs.getString("basisofrecord");
        occurrence.setBasisOfRecord(ObisClient.getBasisOfRecord(basisOfRecord));
        occurrence.setCitation(rs.getString("citation"));
        occurrence.setCredits(credits);
        occurrence.setInstitutionCode(rs.getString("institutioncode"));
        occurrence.setCollectionCode(rs.getString("collectioncode"));
        occurrence.setCatalogueNumber(rs.getString("catalognumber"));
        occurrence.setRecordedBy(rs.getString("collector"));
        String datelastmodified = rs.getString("datelastmodified");
        if (datelastmodified != null) {
            try {
                Date date = DATE_UTIL.parse(datelastmodified);
                Calendar lastmodified = Calendar.getInstance();
                lastmodified.setTimeInMillis(date.getTime());
                occurrence.setModified(lastmodified);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        occurrence.setCountry(rs.getString("country"));
        occurrence.setLocality(rs.getString("locality"));
        occurrence.setMinDepth(rs.getDouble("minimumdepth"));
        occurrence.setMaxDepth(rs.getDouble("maximumdepth"));
        occurrence.setCoordinateUncertaintyInMeters(rs.getString("coordinateprecision"));
        String concatenated = rs.getString("concatenated");
        if (concatenated != null && (authorStartIndex = concatenated.lastIndexOf(124)) > 0 && (scientificNameStartIndex = (snPart = concatenated.substring(0, authorStartIndex)).lastIndexOf(124)) > 0) {
            String author = authorStartIndex + 1 < concatenated.length() ? concatenated.substring(authorStartIndex + 1) : "";
            String sn = scientificNameStartIndex + 1 < snPart.length() ? snPart.substring(scientificNameStartIndex + 1) : "";
            occurrence.setScientificName(sn + " (" + author + ")");
        }
        occurrence.setAuthor(rs.getString("identifiedBy"));
        return occurrence;
    }

    public static OccurrencePoint getOccurrenceById(PluginSession session, String id) throws Exception {
        PreparedStatement statement = session.getOccurrenceByIdPreparedStatement(Integer.parseInt(id));
        ResultSet rs = statement.executeQuery();
        OccurrencePoint occurrence = null;
        String credits = ObisClient.generateCredits();
        if (rs.next()) {
            occurrence = ObisClient.generateOccurrencePoint(rs, credits);
        }
        rs.close();
        return occurrence;
    }

    public static BasisOfRecord getBasisOfRecord(String basis) {
        if (basis == null) {
            return BasisOfRecord.HumanObservation;
        }
        if (basis.equals("HumanObservation")) {
            return BasisOfRecord.HumanObservation;
        }
        if (basis.equalsIgnoreCase("PreservedSpecimen")) {
            return BasisOfRecord.PreservedSpecimen;
        }
        return BasisOfRecord.HumanObservation;
    }

    public static void searchByCommonName(PluginSession session, String searchTerm, SearchFilters filters, Writer<ResultItem> writer) throws Exception {
        PreparedStatement statement = session.getSearchCommonNamePreparedStatement(searchTerm);
        ResultSet rs = statement.executeQuery();
        ObisClient.generateResultItems(session, rs, filters, writer);
    }

    protected static void fillProducts(PluginSession session, int speciesId, int datasetId, String key, SearchFilters filters, ResultItem item) throws SQLException {
        LinkedList<Product> products = new LinkedList<Product>();
        Product occurences = new Product(Capabilities.Occurrence, key);
        int occurencesCount = ObisClient.getOccurrencesCount(session, speciesId, datasetId, filters);
        occurences.setCount(occurencesCount);
        products.add(occurences);
        item.setProducts(products);
    }

    public static void searchByScientificName(PluginSession session, String searchTerm, SearchFilters filters, Writer<ResultItem> writer) throws Exception {
        PreparedStatement statement = session.getSearchScientificNamePreparedStatement(searchTerm);
        ResultSet rs = statement.executeQuery();
        ObisClient.generateResultItems(session, rs, filters, writer);
    }

    protected static void generateResultItems(PluginSession session, ResultSet rs, SearchFilters filters, Writer<ResultItem> writer) throws Exception {
        boolean continueWrite = true;
        String credits = ObisClient.generateCredits();
        String citation = ObisClient.generateCitation();
        while (rs.next() && continueWrite) {
            int id = rs.getInt("id");
            ResultItem baseItem = new ResultItem(String.valueOf(id), "");
            ObisClient.fillTaxon(session, id, (Taxon)baseItem, credits, citation);
            ObisClient.fillCommonNames(session, id, baseItem);
            PreparedStatement datasetStatement = session.getDatasetPreparedStatement(id);
            ResultSet dataSetrs = datasetStatement.executeQuery();
            while (dataSetrs.next()) {
                ResultItem item = Util.cloneResultItem(baseItem);
                int dataSetId = ObisClient.fillDatasetInformation(dataSetrs, item);
                ProductKey key = new ProductKey(id, dataSetId, filters);
                ObisClient.fillProducts(session, id, dataSetId, key.serialize(), filters, item);
                continueWrite = writer.write(item);
            }
        }
        rs.close();
    }

    protected static void fillTaxon(PluginSession session, int id, Taxon taxon, String credits, String citation) throws SQLException {
        PreparedStatement statement = session.getTaxonPreparedStatement(id);
        ResultSet rs = statement.executeQuery();
        if (rs.next()) {
            taxon.setCitation(citation);
            taxon.setCredits(credits);
            taxon.setScientificName(rs.getString("tname"));
            taxon.setAuthor(rs.getString("tauthor"));
            String rank = rs.getString("rank_name");
            taxon.setRank(rank != null ? rank : "");
            int parentId = rs.getInt("parent_id");
            rs.close();
            if (parentId != id) {
                Taxon parent = new Taxon(String.valueOf(parentId));
                ObisClient.fillTaxon(session, parentId, parent, credits, citation);
                taxon.setParent(parent);
            }
        }
    }

    protected static void fillTaxonomyItem(PluginSession session, int id, TaxonomyItem item, String credits, String citation) throws Exception {
        PreparedStatement statement = session.getTaxonPreparedStatement(id);
        ResultSet rs = statement.executeQuery();
        if (rs.next()) {
            item.setScientificName(rs.getString("tname"));
            String author = Util.stripNotValidXMLCharacters(rs.getString("tauthor"));
            item.setAuthor(author);
            item.addProperty(new ElementProperty("worms_id", rs.getString("worms_id")));
            item.addProperty(new ElementProperty("col_id", rs.getString("col_id")));
            item.addProperty(new ElementProperty("irmng_id", rs.getString("irmng_id")));
            item.addProperty(new ElementProperty("itis_id", rs.getString("itis_id")));
            item.setCredits(credits);
            item.setCitation(citation);
            String rank = rs.getString("rank_name");
            item.setRank(rank != null ? rank : "");
            item.setStatus(new TaxonomyStatus("", TaxonomyStatus.Status.ACCEPTED));
            boolean parentNull = rs.getObject("parent_id") == null;
            int parentId = rs.getInt("parent_id");
            rs.close();
            ObisClient.fillCommonNames(session, id, item);
            if (!parentNull && parentId != id) {
                TaxonomyItem parent = taxonomyItemCache.get(parentId);
                if (parent == null) {
                    parent = new TaxonomyItem(String.valueOf(parentId));
                    ObisClient.fillTaxonomyItem(session, parentId, parent, credits, citation);
                }
                item.setParent(parent);
            }
        } else {
            throw new IdNotValidException("Taxon with id " + id + " not found");
        }
    }

    protected static void fillCommonNames(PluginSession session, int taxonNameId, TaxonomyItem item) throws SQLException {
        PreparedStatement statement = session.getTaxonCommonNamePreparedStatement(taxonNameId);
        ResultSet rs = statement.executeQuery();
        ArrayList<CommonName> commonNames = new ArrayList<CommonName>();
        while (rs.next()) {
            commonNames.add(new CommonName(rs.getString("lanname"), rs.getString("cname")));
        }
        rs.close();
        item.setCommonNames(commonNames);
    }

    protected static void fillCommonNames(PluginSession session, int taxonNameId, ResultItem item) throws SQLException {
        PreparedStatement statement = session.getTaxonCommonNamePreparedStatement(taxonNameId);
        ResultSet rs = statement.executeQuery();
        ArrayList<CommonName> commonNames = new ArrayList<CommonName>();
        while (rs.next()) {
            commonNames.add(new CommonName(rs.getString("lanname"), rs.getString("cname")));
        }
        rs.close();
        item.setCommonNames(commonNames);
    }

    protected static int fillDatasetInformation(ResultSet rs, ResultItem item) throws SQLException {
        int dataSetId = rs.getInt("datasetId");
        DataSet dataSet = new DataSet(String.valueOf(dataSetId));
        dataSet.setCitation(rs.getString("datasetCitation"));
        dataSet.setName(rs.getString("datasetName"));
        DataProvider dataProvider = new DataProvider(String.valueOf(rs.getInt("providerId")));
        dataProvider.setName(rs.getString("providerName"));
        dataSet.setDataProvider(dataProvider);
        item.setDataSet(dataSet);
        return dataSetId;
    }

    public static Set<String> getCommonNames(PluginSession session, String scientificName) throws SQLException {
        PreparedStatement statement = session.getCommonNameFromScientificNamePreparedStatement(scientificName);
        ResultSet rs = statement.executeQuery();
        HashSet<String> commonNames = new HashSet<String>();
        while (rs.next()) {
            commonNames.add(rs.getString("cname"));
        }
        rs.close();
        return commonNames;
    }

    public static void getScientificNames(PluginSession session, String commonName, Writer<String> writer) throws SQLException {
        PreparedStatement statement = session.getScientificNameFromCommonNamePreparedStatement(commonName);
        ResultSet rs = statement.executeQuery();
        while (rs.next() && writer.write(rs.getString("tname"))) {
        }
        rs.close();
    }

    public static void getTaxonByScientificNames(PluginSession session, String scientificName, Writer<TaxonomyItem> writer) throws Exception {
        PreparedStatement statement = session.getScientificNamePreparedStatement(scientificName);
        ResultSet rs = statement.executeQuery();
        ObisClient.generateTaxonomyItems(session, rs, writer);
    }

    public static void getTaxonByCommonName(PluginSession session, String commonName, Writer<TaxonomyItem> writer) throws Exception {
        PreparedStatement statement = session.getCommonNamePreparedStatement(commonName);
        ResultSet rs = statement.executeQuery();
        ObisClient.generateTaxonomyItems(session, rs, writer);
    }

    protected static void generateTaxonomyItems(PluginSession session, ResultSet rs, Writer<TaxonomyItem> writer) throws SQLException, Exception {
        boolean continueWrite = true;
        String credits = ObisClient.generateCredits();
        String citation = ObisClient.generateCitation();
        while (rs.next() && continueWrite) {
            Integer id = rs.getInt("id");
            TaxonomyItem taxon = taxonomyItemCache.get(id);
            if (taxon == null) {
                taxon = new TaxonomyItem(String.valueOf(id));
                ObisClient.fillTaxonomyItem(session, id, taxon, credits, citation);
                taxonomyItemCache.put(id, taxon);
            }
            continueWrite = writer.write(taxon);
        }
        rs.close();
    }

    protected static List<TaxonomyItem> getChildrenTaxon(PluginSession session, int id) throws SQLException {
        PreparedStatement statement = session.getChildrenTaxonPreparedStatement(id);
        ResultSet rs = statement.executeQuery();
        ArrayList<TaxonomyItem> children = new ArrayList<TaxonomyItem>();
        while (rs.next()) {
            int taxonId = rs.getInt("id");
            if (taxonId == id) continue;
            TaxonomyItem child = new TaxonomyItem(String.valueOf(taxonId));
            child.setScientificName(rs.getString("tname"));
            child.setCitation(rs.getString("tauthor"));
            String rank = rs.getString("rank_name");
            child.setRank(rank != null ? rank : "");
            child.setStatus(new TaxonomyStatus("", TaxonomyStatus.Status.ACCEPTED));
            ObisClient.fillCommonNames(session, id, child);
            children.add(child);
        }
        rs.close();
        return children;
    }

    protected static TaxonomyItem getTaxonById(PluginSession session, int id) throws Exception {
        TaxonomyItem item = new TaxonomyItem(String.valueOf(id));
        String credits = ObisClient.generateCredits();
        String citation = ObisClient.generateCitation();
        ObisClient.fillTaxonomyItem(session, id, item, credits, citation);
        return item;
    }

    protected static String generateCitation() {
        StringBuilder citation = new StringBuilder("Intergovernmental Oceanographic Commission (IOC) of UNESCO. The Ocean Biogeographic Information System. Web. http://www.iobis.org. (Consulted on ");
        citation.append(sdf.format(Calendar.getInstance().getTime()));
        citation.append(")");
        return citation.toString();
    }

    protected static String generateCredits() {
        StringBuilder credits = new StringBuilder("This information object has been generated via the Species Product Discovery service on ");
        credits.append(sdf.format(Calendar.getInstance().getTime()));
        credits.append(" by interfacing with the Intergovernmental Oceanographic Commission (IOC) of UNESCO. The Ocean Biogeographic Information System. Web. http://www.iobis.org.");
        return credits.toString();
    }

    public static void main(String[] args) throws Exception {
        String url = "jdbc:postgresql://geoserver2.i-marine.research-infrastructures.eu/obis";
        Properties props = new Properties();
        props.setProperty("user", "postgres");
        props.setProperty("password", "0b1s@d4sc13nc3");
        Connection connection = DriverManager.getConnection(url, props);
        System.out.println("Connected");
        PluginSession session = new PluginSession(connection);
        session.preCacheStatements();
        ObisClient.searchByScientificName(session, "gadus morhua", new SearchFilters(new Condition[0]), new Writer<ResultItem>(){

            @Override
            public boolean write(ResultItem item) {
                System.out.println(item.getId() + " " + item.getAuthor() + " " + item.getScientificName());
                return true;
            }
        });
        System.out.println("done");
        session.expire();
    }

    protected static void navigate(String indentation, PluginSession session, int id) throws SQLException {
        if (found.contains(id)) {
            System.err.println("Already found " + id);
            System.err.println(foundTaxon.get(id));
            System.exit(-1);
        }
        List<TaxonomyItem> taxa = ObisClient.getChildrenTaxon(session, id);
        found.add(id);
        for (TaxonomyItem taxon : taxa) {
            System.out.println(indentation + taxon.getId() + " " + taxon.getRank());
            foundTaxon.put(taxon.getId(), taxon);
            ObisClient.navigate(indentation + "  ", session, Integer.valueOf(taxon.getId()));
        }
    }
}

