/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.obisplugin;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.gcube.data.spd.model.OccurrencePoint;
import org.gcube.data.spd.model.Product;
import org.gcube.data.spd.model.Properties;
import org.gcube.data.spd.model.Property;
import org.gcube.data.spd.model.ResultItem;
import org.gcube.data.spd.model.util.Capabilities;
import org.gcube.data.spd.obisplugin.ObisClient;
import org.gcube.data.spd.obisplugin.PluginSession;
import org.gcube.data.spd.obisplugin.Writer;
import org.gcube.data.spd.obisplugin.data.SearchFilters;
import org.gcube.data.spd.obisplugin.pool.PluginSessionPool;
import org.gcube.data.spd.plugin.fwk.capabilities.OccurrencesCapability;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ObisOccurrencesInterface
extends OccurrencesCapability {
    protected Logger logger = Logger.getLogger(ObisOccurrencesInterface.class);
    protected PluginSessionPool sessionPool;

    public ObisOccurrencesInterface(PluginSessionPool sessionPool) {
        this.sessionPool = sessionPool;
    }

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    public void searchByCommonName(String word, final ObjectWriter<OccurrencePoint> writer, Property ... properties) {
        final PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            try {
                SearchFilters filters = new SearchFilters(properties);
                ObisClient.searchByCommonName(session, word, filters, new Writer<ResultItem>(){

                    @Override
                    public boolean write(ResultItem item) {
                        for (Product product : item.getProducts()) {
                            if (product.getType() != Capabilities.Occurences) continue;
                            String key = product.getKey();
                            ObisOccurrencesInterface.this.getOccurrencePoints(session, key, (ObjectWriter<OccurrencePoint>)writer);
                        }
                        return writer.isAlive();
                    }
                });
                writer.close();
            }
            catch (Exception e) {
                this.logger.debug((Object)"searchByCommonName failed", (Throwable)e);
                this.sessionPool.checkIn(session);
            }
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    public void searchByScientificName(String word, final ObjectWriter<OccurrencePoint> writer, Property ... properties) {
        final PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            try {
                SearchFilters filters = new SearchFilters(properties);
                ObisClient.searchByScientificName(session, word, filters, new Writer<ResultItem>(){

                    @Override
                    public boolean write(ResultItem item) {
                        for (Product product : item.getProducts()) {
                            if (product.getType() != Capabilities.Occurences) continue;
                            String key = product.getKey();
                            ObisOccurrencesInterface.this.getOccurrencePoints(session, key, (ObjectWriter<OccurrencePoint>)writer);
                        }
                        return writer.isAlive();
                    }
                });
                writer.close();
            }
            catch (Exception e) {
                this.logger.debug((Object)"searchByScientificName failed", (Throwable)e);
                this.sessionPool.checkIn(session);
            }
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    /*
     * Exception decompiling
     */
    public void getOccurrencesByIds(ObjectWriter<OccurrencePoint> writer, Iterator<String> reader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void getOccurrencesByProductKeys(ObjectWriter<OccurrencePoint> writer, Iterator<String> reader) {
        PluginSession session = (PluginSession)this.sessionPool.checkOut();
        try {
            while (reader.hasNext() && writer.isAlive()) {
                String key = reader.next();
                this.getOccurrencePoints(session, key, writer);
            }
            writer.close();
        }
        finally {
            this.sessionPool.checkIn(session);
        }
    }

    protected void getOccurrencePoints(PluginSession session, String key, final ObjectWriter<OccurrencePoint> writer) {
        try {
            ObisClient.getOccurrences(session, key, new Writer<OccurrencePoint>(){

                @Override
                public boolean write(OccurrencePoint item) {
                    writer.write((Object)item);
                    return writer.isAlive();
                }
            });
        }
        catch (Exception e) {
            this.logger.error((Object)("Error getting occurrence points for key " + key), (Throwable)e);
        }
    }
}

