/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.gcube.data.spd.ncbi.connection.ConnectionPool;
import org.gcube.data.spd.ncbi.connection.ConnectionPoolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTable
extends Thread {
    static Logger logger = LoggerFactory.getLogger(CreateTable.class);

    CreateTable() {
        this.start();
    }

    @Override
    public void run() {
        this.retriveCommonNames();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getacceptednameID(String taxonID) {
        String id = null;
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select id from taxon where taxonremarks = 'scientific name' and taxonid = ?";
            ArrayList<String> terms = new ArrayList<String>();
            terms.add(taxonID);
            rs = pool.selectPrestatement(query, terms, stmt);
            if (rs != null) {
                while (rs.next()) {
                    id = rs.getString(1);
                }
            }
            terms.clear();
        }
        catch (SQLException ex) {
            logger.error("Can't get acceptedname", (Throwable)ex);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
            catch (SQLException ex) {
                logger.error("sql Error", (Throwable)ex);
            }
        }
        return id;
    }

    private String setTaxonomicStatus(String status) {
        String tax = status.equals("scientific name") ? "ACCEPTED" : (status.equals("synonym") || status.equals("genbank synonym") ? "SYNONYM" : "UNKNOWN");
        return tax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retriveCommonNames() {
        ResultSet rs = null;
        ResultSet rs1 = null;
        PreparedStatement stmt = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select a.tax_id, b.name_txt, b.name_class from nodes as a NATURAL JOIN names as b where b.name_class='genbank common name' or b.name_class='common names'";
            Statement statement = con.createStatement();
            rs = statement.executeQuery(query);
            ArrayList<String> terms = new ArrayList<String>();
            while (rs.next()) {
                String taxonID = rs.getString(1);
                String commonName = rs.getString(2);
                String taxonRemarks = rs.getString(3);
                String id = this.getacceptednameID(taxonID);
                String queryInsert = "insert into vernacularnames (scientificnameid, commonName, taxonRemarks) values (?, ?, ?)";
                terms.add(id);
                terms.add(commonName);
                terms.add(taxonRemarks);
                pool.preStatement(queryInsert, terms, stmt);
                terms.clear();
            }
        }
        catch (SQLException ex) {
            logger.error("Can't popolate vernacularnames table", (Throwable)ex);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (rs1 != null) {
                    rs1.close();
                }
                if (pool != null && con != null) {
                    pool.releaseConnection(con);
                }
            }
            catch (SQLException ex) {
                logger.error("sql Error", (Throwable)ex);
            }
        }
    }
}

