/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi.connection;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;
import org.gcube.data.spd.ncbi.NcbiPlugin;
import org.gcube.data.spd.ncbi.connection.ConnectionPoolException;
import org.postgresql.copy.CopyManager;
import org.postgresql.core.BaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionPool {
    static Logger logger = LoggerFactory.getLogger(ConnectionPool.class);
    private static ConnectionPool connectionPool = null;
    private Vector<Connection> freeConnections = new Vector();
    public static String dbUrl;
    private String dbDriver;
    private static String dbLogin;
    private static String dbPassword;

    private ConnectionPool() throws ConnectionPoolException {
        this.loadParameters();
        this.loadDriver();
    }

    private void loadParameters() {
        dbUrl = NcbiPlugin.jdbc;
        this.dbDriver = NcbiPlugin.dbDriver;
        dbLogin = NcbiPlugin.username;
        dbPassword = NcbiPlugin.password;
    }

    private void loadDriver() throws ConnectionPoolException {
        try {
            Class.forName(this.dbDriver).newInstance();
        }
        catch (Exception e) {
            throw new ConnectionPoolException();
        }
    }

    public static synchronized ConnectionPool getConnectionPool() throws ConnectionPoolException {
        if (connectionPool == null) {
            connectionPool = new ConnectionPool();
        }
        return connectionPool;
    }

    public synchronized Connection getConnection() throws ConnectionPoolException {
        Connection con = null;
        if (this.freeConnections.size() > 0) {
            con = this.freeConnections.firstElement();
            this.freeConnections.removeElementAt(0);
            try {
                if (con.isClosed()) {
                    con = this.getConnection();
                }
            }
            catch (SQLException e) {
                con = this.getConnection();
            }
        } else {
            con = this.newConnection();
        }
        return con;
    }

    private Connection newConnection() throws ConnectionPoolException {
        Connection con = null;
        try {
            con = DriverManager.getConnection(dbUrl, dbLogin, dbPassword);
        }
        catch (SQLException e) {
            throw new ConnectionPoolException();
        }
        return con;
    }

    public synchronized void releaseConnection(Connection con) {
        this.freeConnections.add(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preStatement(String query, ArrayList<String> terms, PreparedStatement stmt) {
        ConnectionPool pool = null;
        Connection con = null;
        try {
            int i;
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            stmt = con.prepareStatement(query);
            for (i = 0; i < terms.size(); ++i) {
                stmt.setString(i + 1, terms.get(i));
            }
            stmt.executeUpdate();
            i = 1;
            return i != 0;
        }
        catch (SQLException sqle) {
            logger.trace("Error executing: " + stmt);
            boolean bl = false;
            return bl;
        }
        catch (ConnectionPoolException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet selectPrestatement(String query, ArrayList<String> terms, PreparedStatement stmt) {
        ResultSet result = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            stmt = con.prepareStatement(query);
            for (int i = 0; i < terms.size(); ++i) {
                stmt.setString(i + 1, terms.get(i));
            }
            result = stmt.executeQuery();
        }
        catch (SQLException e) {
            logger.error("SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                stmt.clearParameters();
            }
            catch (SQLException e) {
                logger.error("SQLException", (Throwable)e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insertPreStatement(String query) {
        PreparedStatement stmt = null;
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            stmt = con.prepareStatement(query);
            stmt.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (SQLException sqle) {
            logger.trace("Error executing: " + stmt);
            boolean bl = false;
            return bl;
        }
        catch (ConnectionPoolException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean copy(String query, String file) {
        Connection con = null;
        try {
            Class.forName(NcbiPlugin.dbDriver).newInstance();
            con = DriverManager.getConnection(NcbiPlugin.jdbc, NcbiPlugin.username, NcbiPlugin.password);
            CopyManager copyManager = new CopyManager((BaseConnection)con);
            FileReader fileReader = new FileReader(file);
            copyManager.copyIn(query, (Reader)fileReader);
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return true;
    }
}

