/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.gcube.data.spd.ncbi.NcbiPlugin;
import org.gcube.data.spd.ncbi.Utils;
import org.gcube.data.spd.ncbi.connection.ConnectionPool;
import org.gcube.data.spd.ncbi.connection.ConnectionPoolException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UpdateThread
extends Thread {
    long nextup;
    static Logger logger = LoggerFactory.getLogger(UpdateThread.class);

    UpdateThread(long update) {
        this.nextup = update;
        this.start();
    }

    @Override
    public void run() {
        while (true) {
            logger.trace(this.createLabel(this.nextup));
            try {
                UpdateThread.sleep(this.nextup);
                if (!this.update()) continue;
                this.setlastupdate();
                this.nextup = 2592000000L;
                continue;
            }
            catch (InterruptedException e) {
                logger.error("InterruptedException", (Throwable)e);
                continue;
            }
            catch (IOException e) {
                logger.error("IOException", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private String createLabel(long nextup) {
        java.util.Date date = new java.util.Date();
        String label = "NCBI DB will be updated on " + Utils.nextUpdateDate(nextup + date.getTime());
        return label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setlastupdate() {
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            java.util.Date date = new java.util.Date();
            long dt = date.getTime();
            Date today = new Date(dt);
            String query = "insert into updates (date) values ('" + today + "')";
            boolean result = ConnectionPool.insertPreStatement(query);
            if (!result) {
                logger.trace("problem setting last update date");
            }
        }
        catch (ConnectionPoolException e) {
            logger.error("ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean update() throws IOException {
        logger.trace("update");
        File tempFolder = null;
        try {
            URL url = new URL(NcbiPlugin.urlDump);
            tempFolder = File.createTempFile("ncbi-folder", "");
            tempFolder.delete();
            tempFolder.mkdir();
            if (this.downloadFromUrl(url, tempFolder + "/" + "taxdump.tar.gz")) {
                Runtime rt1 = Runtime.getRuntime();
                Process runtimeProcess1 = null;
                logger.trace("tar xzvf " + tempFolder + "/" + "taxdump.tar.gz" + " -C " + tempFolder);
                runtimeProcess1 = rt1.exec("tar xzvf " + tempFolder + "/" + "taxdump.tar.gz" + " -C " + tempFolder);
                runtimeProcess1.waitFor();
                this.importData(tempFolder);
                if (this.importData(tempFolder).booleanValue()) {
                    this.createTableCit();
                }
            }
            if (tempFolder != null) {
                this.clearTmp(tempFolder);
            }
        }
        catch (Exception e) {
            try {
                logger.error("Error Downloading Dump", (Throwable)e);
                boolean bl = false;
                if (tempFolder != null) {
                    this.clearTmp(tempFolder);
                }
                return bl;
            }
            catch (Throwable throwable) {
                if (tempFolder != null) {
                    this.clearTmp(tempFolder);
                }
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean createTableCit() {
        logger.trace("creating table citation");
        ResultSet rs = null;
        Connection con = null;
        Statement statement = null;
        PreparedStatement stmt = null;
        try {
            con = DriverManager.getConnection(NcbiPlugin.jdbc, NcbiPlugin.username, NcbiPlugin.password);
            if (Utils.SQLTableExists("citation")) {
                logger.trace("drop table citation cascade");
                stmt = con.prepareStatement("drop table citation cascade");
                stmt.executeUpdate();
                stmt.cancel();
            }
            statement = con.createStatement();
            rs = statement.executeQuery("select cit_id, taxid_list from citations");
            while (rs.next()) {
                String[] list;
                int cit_id = rs.getInt(1);
                String taxid_list = rs.getString(2);
                if (taxid_list == null) continue;
                for (String tax_id : list = taxid_list.split(" ")) {
                    stmt = con.prepareStatement("insert into citation(tax_id, cit_id) values (" + tax_id + ", " + cit_id + ")");
                    stmt.executeUpdate();
                }
            }
        }
        catch (SQLException ex) {
            logger.error("Can't create citation table", (Throwable)ex);
            Boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.error("sql Error", (Throwable)ex);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downloadFromUrl(URL url, String localFilename) {
        Boolean flag = false;
        logger.trace("Downloading from " + url + " ...");
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int len;
            URLConnection urlConn = url.openConnection();
            is = urlConn.getInputStream();
            fos = new FileOutputStream(localFilename);
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            logger.trace("Download completed successfully");
            flag = true;
        }
        catch (IOException e) {
            logger.error("Error, check url", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.error("IOException Error", (Throwable)e);
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error("IOException Error", (Throwable)e);
                }
            }
        }
        return flag;
    }

    private void clearTmp(File f) {
        if (f.exists()) {
            for (File c : f.listFiles()) {
                if (c.isDirectory()) {
                    this.clearTmp(c);
                }
                c.delete();
            }
            f.delete();
        }
        logger.trace("Deleted files");
    }

    private Boolean importData(File tempFolder) throws SQLException, IOException {
        if (tempFolder.isDirectory()) {
            logger.trace("Starting import from:");
            for (String n : NcbiPlugin.names) {
                File f = new File(tempFolder + "/" + n + ".dmp");
                if (!f.getName().toLowerCase().endsWith("dmp")) continue;
                String table = null;
                int index = f.getName().lastIndexOf(46);
                if (index > 0 && index <= f.getName().length() - 2) {
                    table = f.getName().substring(0, index);
                }
                this.getFileContent(tempFolder, f.getPath(), table);
                File tab = new File(tempFolder + "/" + table);
                ConnectionPool pool = null;
                try {
                    pool = ConnectionPool.getConnectionPool();
                    pool.copy("copy " + table + " from stdin DELIMITERS '\t' CSV", tab.getAbsolutePath());
                    logger.trace(f.getName());
                }
                catch (Exception e) {
                    logger.error("Exception", (Throwable)e);
                    return false;
                }
            }
            logger.trace("Import completed successfully!");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getFileContent(File tempFolder, String path, String output) throws FileNotFoundException, IOException {
        logger.trace("getContent " + path + " " + output);
        BufferedWriter bw = new BufferedWriter(new FileWriter(tempFolder + "/" + output));
        FileInputStream in = new FileInputStream(path);
        InputStreamReader r = new InputStreamReader(in);
        StringBuilder line = new StringBuilder();
        Integer count = 0;
        Integer tab = 0;
        Integer quot = 0;
        int before = 0;
        ResultSet rs = null;
        PreparedStatement stmt = null;
        Connection con = null;
        try {
            int intch;
            con = DriverManager.getConnection(NcbiPlugin.jdbc, NcbiPlugin.username, NcbiPlugin.password);
            logger.trace("select * from " + output + " LIMIT 1");
            stmt = con.prepareStatement("select * from " + output + " LIMIT 1");
            rs = stmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            tab = rsmd.getColumnCount();
            while ((intch = ((Reader)r).read()) != -1) {
                Integer n;
                Integer n2;
                char ch = (char)intch;
                if (ch == '|' & before == 9) {
                    n2 = count;
                    n = count = Integer.valueOf(count + 1);
                    if (count == tab) {
                        if (quot != 0 & quot % 2 != 0) {
                            String new_line = line.toString().replace("\"", "");
                            bw.write(new_line.toString());
                        } else {
                            bw.write(line.toString());
                        }
                        bw.write(10);
                        line.delete(0, line.length());
                        count = 0;
                        quot = 0;
                    } else {
                        line.append('\t');
                    }
                } else if (ch != '|' & ch != '\n' & ch != '\t') {
                    line.append(ch);
                    if (ch == '\"') {
                        n2 = quot;
                        n = quot = Integer.valueOf(quot + 1);
                    }
                }
                before = ch;
            }
            bw.close();
            ((InputStream)in).close();
            ((Reader)r).close();
        }
        catch (SQLException e) {
            logger.error("sql Error", (Throwable)e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.error("sql Error", (Throwable)ex);
            }
        }
    }
}

