/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.ncbi.capabilities;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.ncbi.connection.ConnectionPool;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;

public class NamesMappingImpl
implements NamesMappingCapability {
    private static GCUBELog logger = new GCUBELog(NamesMappingImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> commonNameToScientificNamesMapping(String commonName) {
        logger.trace((Object)("commonNameToScientificNamesMapping for commonName " + commonName + " in NCBI..."));
        HashSet<String> set = new HashSet<String>();
        ResultSet rs = null;
        ResultSet res1 = null;
        ConnectionPool pool = null;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            ArrayList<String> terms = new ArrayList<String>();
            terms.add("%" + commonName + "%");
            rs = pool.selectPrestatement("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER(?)", terms, stmt);
            while (rs.next()) {
                String id = rs.getString(1);
                ArrayList<String> terms1 = new ArrayList<String>();
                terms1.add(id);
                res1 = pool.selectPrestatement("select name_txt from names where name_class = 'scientific name' and tax_id = ?", terms1, stmt);
                if (res1.next()) {
                    String name = res1.getString(1);
                    set.add(name);
                }
                terms1.clear();
            }
            terms.clear();
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            logger.error((Object)"general Error", e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> scientificNameToCommonNamesMapping(String scientificName) {
        logger.trace((Object)("scientificNameToCommonNamesMapping for scientificName " + scientificName + " in NCBI..."));
        HashSet<String> set = new HashSet<String>();
        ResultSet rs1 = null;
        ResultSet rs2 = null;
        ConnectionPool pool = null;
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            ArrayList<String> terms = new ArrayList<String>();
            terms.add("%" + scientificName + "%");
            ArrayList<String> terms1 = new ArrayList<String>();
            rs1 = pool.selectPrestatement("select distinct(tax_id) from names where name_class = 'scientific name' and UPPER(name_txt) like UPPER(?)", terms, stmt);
            while (rs1.next()) {
                String id = rs1.getString(1);
                terms1.add(id);
                rs2 = pool.selectPrestatement("select name_txt from names where name_class = 'common name' and tax_id = ?", terms1, stmt);
                while (rs2.next()) {
                    String name = rs2.getString(1);
                    set.add(name);
                }
                terms1.clear();
            }
            terms.clear();
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (Throwable e) {
            logger.error((Object)"general Error", e);
        }
        finally {
            try {
                if (rs1 != null) {
                    rs1.close();
                }
                if (rs2 != null) {
                    rs2.close();
                }
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
        return set;
    }
}

