package org.gcube.data.spd.ncbi.capabilities;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.ncbi.Database;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;




public class NamesMappingImpl implements NamesMappingCapability{

	private static GCUBELog logger = new GCUBELog(NamesMappingImpl.class);

	@Override
	public Set<Properties> getSupportedProperties() {
		return Collections.emptySet();
	}

	@Override
	public Set<String> commonNameToScientificNamesMapping(String commonName) throws Exception {

		logger.trace("commonNameToScientificNamesMapping for commonName "+commonName+" in NCBI...");
		Set<String> set = new HashSet<String>();

		ResultSet rs = null;
		ResultSet res1 = null;
		
		Database database = null;  
		try {
			database = new Database();  			
			database.connect();

			//			logger.trace("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER('%" + commonName + "%')");
			rs = database.get("select distinct(tax_id) from names where name_class = 'common name' and UPPER(name_txt) like UPPER('%" + commonName + "%')");

			while(rs.next()) {	
				int id = rs.getInt(1);

				//				logger.trace("select name_txt from names where name_class = 'scientific name' and tax_id = " + id_cm );
				res1 = database.get("select name_txt from names where name_class = 'scientific name' and tax_id = " + id  );

				if(res1.next()){	
					String name = res1.getString(1);
					set.add(name);
				}
			}

			//			logger.trace("commonNameToScientificNamesMapping finished for commonName "+commonName+" in NCBI");
		}

		catch (SQLException sqlExcept) {
			logger.error("sql Error", sqlExcept);
		}catch (Throwable e) {
			logger.error("general Error", e);
		} finally {
			try {
				if (rs != null) 
					rs.close();
				
					database.shutDown();
				
			} catch (SQLException ex) {
				logger.error("sql Error", ex);

			}
		}

		return set;
	}

	@Override
	public Set<String> scientificNameToCommonNamesMapping(String scientificName) throws Exception {

		logger.trace("scientificNameToCommonNamesMapping for scientificName "+scientificName+" in NCBI...");
		Set<String> set = new HashSet<String>();
		
		ResultSet rs1 = null;
		ResultSet rs2 = null;
		
		Database database = null;  
		try {
			database = new Database();  			
			database.connect();

			//			logger.trace("select distinct(tax_id) from names where name_class = 'scientific name' and UPPER(name_txt) like UPPER('%" + scientificName + "%')");
			rs1 = database.get("select distinct(tax_id) from names where name_class = 'scientific name' and UPPER(name_txt) like UPPER('%" + scientificName + "%')");

			while(rs1.next()) {	
				int id = rs1.getInt(1);
				
				//				logger.trace("select name_txt from names where name_class = 'common name' and tax_id = " + id  );
				rs2 = database.get("select name_txt from names where name_class = 'common name' and tax_id = " + id  );

				while(rs2.next()) {	
					String name = rs2.getString(1);
					//					logger.trace(name);
					set.add(name);
				}
			}

			//			logger.trace("scientificNameToCommonNamesMapping finished for scientificName "+scientificName+" in NCBI");
		}

		catch (SQLException sqlExcept)
		{
			logger.error("sql Error", sqlExcept);
		}catch (Throwable e) {
			logger.error("general Error", e);
		} finally {
			try {
				if (rs1 != null) 
					rs1.close();
				if (rs2 != null) 
					rs2.close();
			
					database.shutDown();				

			} catch (SQLException ex) {
				logger.error("sql Error", ex);

			}
		}

		return set;
	}


}
