package org.gcube.data.spd.ncbi;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Hashtable;

import org.gcube.common.core.utils.logging.GCUBELog;

class UpdateThread extends Thread {

//	ArrayList<String> tables = new ArrayList<String>();


	static GCUBELog logger = new GCUBELog(UpdateThread.class);

	UpdateThread() {
		//	super("Thread");
		start(); // Start the thread
	}

	public void run() {
		try {
			while (true){

				try {
					update();
					sleep(2592000000L);
					
				} catch (InterruptedException e) {
					logger.error("InterruptedException", e);
				}
			}
		} catch (IOException e) {
			logger.error("IOException", e);
		}
	}
	
	
	//	get information (author or rank) by Id
	protected void update() throws IOException{

		try {

//			tables.put("nodes", "create table nodes(tax_id integer NOT NULL PRIMARY KEY,parent_tax_id integer NOT NULL references nodes(tax_id) ON DELETE CASCADE, rank varchar(128),embl_code varchar(64),division_id integer,inherited_div_flag boolean,genetic_code_id integer, inherited_GC_flag boolean,mitochondrial_genetic_code_id integer,inherited_MGC_flag boolean,GenBank_hidden_flag boolean,hidden_subtree_root_flag boolean,comments varchar)");
//			tables.put("delnodes", "create table delnodes(tax_id integer)");
//			tables.put("merged", "create table merged(old_tax_id integer,new_tax_id integer)");
//			tables.put("citations", "create table citations(cit_id integer NOT NULL PRIMARY KEY,cit_key varchar(255),pubmed_id integer default 0,medline_id integer default 0,url text,text text,taxid_list varchar)");
//			tables.put("names", "create table names(tax_id integer NOT NULL references nodes(tax_id) ON DELETE CASCADE,name_txt text,unique_name varchar(255),name_class varchar(128))");
//			tables.put("division", "create table division(division_id integer NOT NULL PRIMARY KEY,division_code varchar(4),division_name varchar(64),comments varchar)");
//			tables.put("gencode", "create table gencode(genetic_code_id integer NOT NULL PRIMARY KEY,abbreviation varchar(64),name text,cde text,starts varchar(255))");
//			tables.put("citation", "create table citation(tax_id integer NOT NULL references nodes(tax_id) ON DELETE CASCADE, cit_id integer NOT NULL references citations(cit_id) ON DELETE CASCADE)");
			
			URL url = new URL(NcbiPlugin.urlDump);

			//create a temp folder
			File tempFolder = File.createTempFile("ncbi-folder", "" );
			tempFolder.delete();
			tempFolder.mkdir();

			//get dump from URL http://www.Ncbi.gov/downloads/NcbiMySQLTables.tar.gz

			if (downloadFromUrl(url, tempFolder + "/" + NcbiPlugin.zipFileName)) {

				//decompress
				Runtime rt1 = Runtime.getRuntime(); 
				Process runtimeProcess1 = null; 
				logger.trace("tar xzvf " + tempFolder + "/" + NcbiPlugin.zipFileName + " -C " + tempFolder);
				runtimeProcess1 = rt1.exec("tar xzvf " + tempFolder + "/" + NcbiPlugin.zipFileName + " -C " + tempFolder);			
				runtimeProcess1.waitFor();

				//import data
				importData(tempFolder);	
				//delete temp folder
				clearTmp(tempFolder);
				//create table citation
				createTableCit();			
			}
		} catch (Exception e) {
			logger.error("Error Downloading Dump", e);
		}
	}

	private void createTableCit() {

		ResultSet rs = null;

		Database database = null;  
		try {
			database = new Database();  			
			database.connect();
//			logger.trace("open1");

//			if (SQLTableExists("citation")){
//
//				logger.trace("drop table citation cascade");
//				database.update("drop table citation cascade");
//			}
//			logger.trace(tables.get("citation"));	
//			database.update(tables.get("citation"));	

			rs = database.get("select cit_id, taxid_list from citations");

			while(rs.next()) {	
				String[] list;
				int cit_id = rs.getInt(1);
				String taxid_list = rs.getString(2);

				if (taxid_list != null) {
					list = taxid_list.split(" ");

					for (String  tax_id : list) {
						//logger.trace("insert into citation(tax_id, cit_id) values (" + tax_id + ", " + cit_id + ")");
						database.update("insert into citation(tax_id, cit_id) values (" + tax_id + ", " + cit_id + ")");
					}
				}			
			}	
		} catch (SQLException ex) {
			logger.error("Can't create citation table", ex);

		} finally {
			try {
				
				if (rs != null) 
					rs.close();
				database.shutDown();
//				logger.trace("close1");
			} catch (SQLException ex) {
				logger.error("sql Error", ex);
			}
		}
	}


	//check if the tables already exist
	private boolean SQLTableExists(String tableName) {

		boolean exists = false;
		ResultSet rs = null;

		Database database = null;  
		try {
			database = new Database();  			
			database.connect();
			
			String sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'";    
			rs = database.get(sqlText);

			if (rs.next()) {
				exists = true;
			} else { 
				exists = false;
			}
		} catch (SQLException e) {
			logger.error("SQLException in SQLTableExists", e);
		}finally {

			try {
				if (rs != null) 
					rs.close();
			} catch (SQLException e) {

				logger.error("SQLException", e);
			}
		} 
		return exists;
	}

	
	
	//download dump DB 
	private boolean downloadFromUrl(URL url, String localFilename) {

		Boolean flag = false;
		logger.trace("Downloading from " + url + " ...");
		InputStream is = null;
		FileOutputStream fos = null;

		try {
			URLConnection urlConn = url.openConnection();

			is = urlConn.getInputStream();
			fos = new FileOutputStream(localFilename);

			byte[] buffer = new byte[4096];
			int len;

			while ((len = is.read(buffer)) > 0) {
				fos.write(buffer, 0, len);
			}
			logger.trace("Download completed successfully");
			flag = true;

		} catch(IOException e){
			logger.error("Error, check url", e);

		}finally {
			try {

			} finally {
				if (is != null)
					try {
						is.close();
					} catch (IOException e) {						
						logger.error("IOException Error", e);
					}
				if (fos != null)
					try {
						fos.close();
					} catch (IOException e) {
						logger.error("IOException Error", e);
					}
			}
		}
		return flag;
	}
	//delete content folder
	private void clearTmp(File f) {
		if (f.exists()) {
			for (File c : f.listFiles()) {
				if (c.isDirectory())
					clearTmp(c);
				c.delete();
			}
			f.delete();
		}
		logger.trace("Deleted files");
	}


	//metod called by CreateDBThread

	private void importData(File tempFolder) throws SQLException, IOException {

		Hashtable<String, String> tables = new Hashtable<String, String>();

		tables.put("nodes", "create table nodes(tax_id integer NOT NULL PRIMARY KEY,parent_tax_id integer NOT NULL references nodes(tax_id) ON DELETE CASCADE, rank varchar(128),embl_code varchar(64),division_id integer,inherited_div_flag boolean,genetic_code_id integer, inherited_GC_flag boolean,mitochondrial_genetic_code_id integer,inherited_MGC_flag boolean,GenBank_hidden_flag boolean,hidden_subtree_root_flag boolean,comments varchar)");
		tables.put("delnodes", "create table delnodes(tax_id integer)");
		tables.put("merged", "create table merged(old_tax_id integer,new_tax_id integer)");
		tables.put("citations", "create table citations(cit_id integer NOT NULL PRIMARY KEY,cit_key varchar(255),pubmed_id integer default 0,medline_id integer default 0,url text,text text,taxid_list varchar)");
		tables.put("names", "create table names(tax_id integer NOT NULL references nodes(tax_id) ON DELETE CASCADE,name_txt text,unique_name varchar(255),name_class varchar(128))");
		tables.put("division", "create table division(division_id integer NOT NULL PRIMARY KEY,division_code varchar(4),division_name varchar(64),comments varchar)");
		tables.put("gencode", "create table gencode(genetic_code_id integer NOT NULL PRIMARY KEY,abbreviation varchar(64),name text,cde text,starts varchar(255))");
		tables.put("citation", "create table citation(tax_id integer NOT NULL references nodes(tax_id) ON DELETE CASCADE, cit_id integer NOT NULL references citations(cit_id) ON DELETE CASCADE)");

		if (tempFolder.isDirectory()) {

			logger.trace("Starting import from:");

			for (String n : NcbiPlugin.names) {
				File f = new File(tempFolder + "/" + n + ".dmp");
				if (f.getName().toLowerCase().endsWith("dmp")) {												

					//get table name
					String table = null;					
					int index = f.getName().lastIndexOf('.');
					if (index>0 && index <= f.getName().length() - 2 )
						table = f.getName().substring(0, index);					

					getFileContent(tempFolder, f.getPath(), table);
					File tab = new File(tempFolder + "/" + table);

					Database database = null;  
					try {
						database = new Database();  			
						database.connect();

						//drop table
						if (SQLTableExists(table)){
							logger.trace("drop table " + table + " cascade");
							database.update("drop table " + table + " cascade");
						}
						
						//create table
						database.update(tables.get(table));
						logger.trace(tables.get(table));

						logger.trace("copy " + table + " from '" + tab.getAbsolutePath() +"' WITH DELIMITER '\t' CSV");
						database.update("copy " + table + " from '" + tab.getAbsolutePath() +"' WITH DELIMITER '\t' CSV");

						logger.trace(f.getName());
					} finally {
						database.shutDown();
//						logger.trace("close2");
					}
				}
			}
			logger.trace("Import completed successfully!");
		}


	}

	//clean csv and create a new file with the same content
	private void getFileContent(File tempFolder, String path, String output) throws FileNotFoundException, IOException{ 
			logger.trace("getContent " + path +" " + output);

		//		BufferedReader br =  new BufferedReader(new FileReader(path)); 
		BufferedWriter bw = new BufferedWriter(new FileWriter(tempFolder + "/" + output));
		InputStream in = new FileInputStream(path);
		Reader r = new InputStreamReader(in);
		int intch;
		StringBuilder line = new StringBuilder();
		Integer count = 0;
		Integer tab = 0;
		Integer quot = 0;
		char before = 0;
		ResultSet rs = null;

		Database database = null;  
		try {
			database = new Database();  			
			database.connect();
			logger.trace("select * from " + output + " LIMIT 1");
			rs = database.get("select * from " + output + " LIMIT 1");
			ResultSetMetaData rsmd = rs.getMetaData();
			tab = rsmd.getColumnCount();
			//						logger.trace(tab);
			//clean csv
			while ((intch = r.read()) != -1) {
				char ch = (char) intch;

				if ((ch == '|') & (before == '\t')) {			
					count++;
					if (count == tab) {		
						if ((quot != 0) & (quot%2!=0)) {
							String new_line =(line.toString()).replace("\""+"", "");
							bw.write(new_line.toString());
						}
						else
							bw.write(line.toString());
						bw.write('\n');
						line.delete(0, line.length());
						count = 0;
						quot = 0;
					}
					else
						line.append('\t');	
				}
				else if (((ch != '|') &(ch != '\n') & (ch != '\t'))) {
					line.append(ch);
					if (ch == '\"') {
						quot++;
					}
				}
				before = ch;
			}
			bw.close();
			in.close();
			r.close();
		} catch (SQLException e) {
			logger.error("sql Error", e);
		} finally {
			try {
				if (rs != null) 
					rs.close();	
				database.shutDown();
//				logger.trace("close A");
			} catch (SQLException ex) {
				logger.error("sql Error", ex);

			}
		}
	} 


}

