/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.itis;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.itis.ItisPlugin;
import org.gcube.data.spd.itis.dbconnection.ConnectionPool;
import org.gcube.data.spd.itis.dbconnection.ConnectionPoolException;

class UpdateThread
extends Thread {
    static GCUBELog logger = new GCUBELog(UpdateThread.class);
    private long nextup;

    UpdateThread(long update) {
        this.nextup = update;
        this.start();
    }

    @Override
    public void run() {
        java.util.Date date = new java.util.Date();
        logger.trace((Object)("ITIS DB will be updated on " + this.nextUpdateDate(this.nextup + date.getTime())));
        try {
            while (true) {
                UpdateThread.sleep(this.nextup);
                this.update();
                this.nextup = 2592000000L;
                UpdateThread.createTableUpdates();
                this.setlastupdate();
            }
        }
        catch (IOException e) {
            logger.error((Object)"IOException", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error((Object)"InterruptedException", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setlastupdate() {
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            java.util.Date date = new java.util.Date();
            long dt = date.getTime();
            Date today = new Date(dt);
            String query = "insert into updates (date) values ('" + today + "')";
            boolean result = pool.insertPreStatement(query);
            if (!result) {
                logger.trace((Object)"problem setting last update date");
            }
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTableUpdates() {
        ConnectionPool pool = null;
        Connection con = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            logger.trace((Object)"Create table updates...");
            String query = "create table updates (id serial NOT NULL PRIMARY KEY, date date)";
            boolean result = pool.insertPreStatement(query);
            if (!result) {
                logger.trace((Object)query);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
    }

    private String nextUpdateDate(long input) {
        java.util.Date date = new java.util.Date(input);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        return dateFormat.format(date);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() throws IOException {
        File tempFolder = null;
        try {
            block12: {
                URL url = new URL("http://www.itis.gov/downloads/itisMySQLTables.tar.gz");
                tempFolder = File.createTempFile("itis-folder", "");
                tempFolder.delete();
                tempFolder.mkdir();
                String folder = null;
                if (this.downloadFromUrl(url, tempFolder + "/" + "itisMySQLTables.tar.gz")) {
                    Runtime rt1 = Runtime.getRuntime();
                    Process runtimeProcess1 = null;
                    logger.trace((Object)("tar xzvf " + tempFolder + "/" + "itisMySQLTables.tar.gz" + " -C " + tempFolder));
                    runtimeProcess1 = rt1.exec("tar xzvf " + tempFolder + "/" + "itisMySQLTables.tar.gz" + " -C " + tempFolder);
                    runtimeProcess1.waitFor();
                    File f = new File(tempFolder + "/" + "itisMySQLTables.tar.gz");
                    if (f.exists()) {
                        f.delete();
                    }
                    Process p = Runtime.getRuntime().exec("ls " + tempFolder);
                    BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String line = null;
                    line = in.readLine();
                    if (line != null) {
                        folder = line + "/";
                    }
                    if (folder != null) {
                        String fileContent = this.getFileContent(tempFolder + "/" + folder + "dropcreateloaditis.sql").replace("LOAD DATA LOCAL INFILE '", "LOAD DATA LOCAL INFILE '" + tempFolder + "/" + folder);
                        this.setFileContent(tempFolder + "/" + folder + "dropcreateloaditis.sql", fileContent);
                        Runtime rt = Runtime.getRuntime();
                        logger.trace((Object)("mysql -h " + ItisPlugin.hostName + " -u " + ItisPlugin.user + " --password=" + ItisPlugin.password + " --enable-local-infile < " + tempFolder + "/" + folder + "dropcreateloaditis.sql"));
                        String[] executeCmd = new String[]{"/bin/sh", "-c", "mysql -h " + ItisPlugin.hostName + " -u " + ItisPlugin.user + " --password=" + ItisPlugin.password + " --enable-local-infile < " + tempFolder + "/" + folder + "dropcreateloaditis.sql"};
                        Process runtimeProcess = null;
                        try {
                            runtimeProcess = rt.exec(executeCmd);
                            runtimeProcess.waitFor();
                            int processComplete = runtimeProcess.waitFor();
                            if (processComplete == 0) {
                                logger.trace((Object)"Database created successfully");
                                break block12;
                            }
                            logger.trace((Object)"Could not create the database");
                        }
                        catch (Exception ex) {
                            logger.error((Object)this.loadStream(runtimeProcess.getErrorStream()), (Throwable)ex);
                        }
                    }
                } else {
                    logger.warn((Object)"Download failed");
                }
            }
            this.emptyFolder(tempFolder);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"General Error", (Throwable)e);
                this.emptyFolder(tempFolder);
            }
            catch (Throwable throwable) {
                this.emptyFolder(tempFolder);
                throw throwable;
            }
        }
    }

    private String loadStream(InputStream in) throws IOException {
        int ptr = 0;
        in = new BufferedInputStream(in);
        StringBuffer buffer = new StringBuffer();
        while ((ptr = in.read()) != -1) {
            buffer.append((char)ptr);
        }
        return buffer.toString();
    }

    public void emptyFolder(File f) {
        try {
            if (f.exists()) {
                for (File c : f.listFiles()) {
                    if (c.isDirectory()) {
                        this.emptyFolder(c);
                    }
                    c.delete();
                }
                f.delete();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error deleting folder " + f), (Throwable)e);
        }
    }

    public void setFileContent(String string, String content) throws FileNotFoundException, IOException {
        FileOutputStream fos = new FileOutputStream(string);
        fos.write(content.getBytes());
        fos.close();
    }

    public String getFileContent(String path) throws FileNotFoundException, IOException {
        String content = "";
        BufferedReader br = new BufferedReader(new FileReader(path));
        while (br.ready()) {
            content = content + "\n" + br.readLine();
        }
        br.close();
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFromUrl(URL url, String localFilename) throws IOException {
        boolean flag = false;
        logger.trace((Object)("Downloading " + localFilename));
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            int len;
            URLConnection urlConn = url.openConnection();
            is = urlConn.getInputStream();
            fos = new FileOutputStream(localFilename);
            byte[] buffer = new byte[4096];
            while ((len = is.read(buffer)) > 0) {
                fos.write(buffer, 0, len);
            }
            flag = true;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            finally {
                if (fos != null) {
                    fos.close();
                }
            }
        }
        return flag;
    }
}

