/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.itis;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.itis.Database;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.capabilities.NamesMappingCapability;

public class NamesMappingImpl
implements NamesMappingCapability {
    GCUBELog logger = new GCUBELog(NamesMappingImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    public Set<String> commonNameToScientificNamesMapping(String commonName) throws Exception {
        Set<String> set = this.mapping("common_name", commonName);
        return set;
    }

    public Set<String> scientificNameToCommonNamesMapping(String scientificName) throws Exception {
        Set<String> set = this.mapping("scientific_name", scientificName);
        return set;
    }

    public Set<String> mapping(String type, String name) throws Exception {
        HashSet<String> names = new HashSet<String>();
        ResultSet rs = null;
        Database database = new Database();
        if (database.connect()) {
            try {
                try {
                    if (type.equals("scientific_name")) {
                        rs = database.get("select vernacular_name from longnames natural join vernaculars where UPPER(completename) like UPPER('%" + name + "%') order by vernacular_name");
                    } else if (type.equals("common_name")) {
                        rs = database.get("select completename from longnames natural join vernaculars where UPPER(vernacular_name) like UPPER('%" + name + "%') order by completename");
                    }
                    while (rs.next()) {
                        names.add(rs.getString(1));
                    }
                }
                catch (SQLException e) {
                    this.logger.error((Object)"SQL Error", (Throwable)e);
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        database.shutDown();
                    }
                    catch (SQLException ex) {
                        this.logger.error((Object)"SQL Error", (Throwable)ex);
                    }
                }
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    database.shutDown();
                }
                catch (SQLException ex) {
                    this.logger.error((Object)"SQL Error", (Throwable)ex);
                }
            }
        } else {
            this.logger.trace((Object)"No database connection");
        }
        return names;
    }
}

