/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.irmng.DateUtil;
import org.gcube.data.spd.irmng.IrmngPlugin;
import org.gcube.data.spd.irmng.dbconnection.ConnectionPool;
import org.gcube.data.spd.irmng.dbconnection.ConnectionPoolException;
import org.postgresql.util.PSQLException;

public class Utils {
    static GCUBELog logger = new GCUBELog(Utils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean SQLTableExists(String tableName) {
        boolean exists = false;
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            String sqlText = "SELECT tables.table_name FROM information_schema.tables WHERE table_name = '" + tableName + "'";
            results = statement.executeQuery(sqlText);
            exists = results.next();
        }
        catch (SQLException e) {
            logger.error((Object)"SQLException", (Throwable)e);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"sql Error", (Throwable)ex);
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createDB() throws SQLException, IOException {
        ConnectionPool pool = null;
        Connection con = null;
        try {
            String line;
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            Statement statement = con.createStatement();
            BufferedReader br = new BufferedReader(new InputStreamReader(IrmngPlugin.class.getResourceAsStream("/createIrmngDb.sql")));
            while ((line = br.readLine()) != null) {
                try {
                    int updateQuery = statement.executeUpdate(line);
                    if (updateQuery != 1) continue;
                    logger.trace((Object)("Error executing : " + line));
                    boolean bl = false;
                    return bl;
                }
                catch (PSQLException e) {
                    logger.trace((Object)"Exception creating tables", (Throwable)e);
                }
            }
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return true;
    }

    public static Calendar getCalendar(String date1) {
        Calendar cal = null;
        Date date = DateUtil.getInstance().parse(date1);
        if (date != null) {
            cal = Calendar.getInstance();
            cal.setTime(new Date(date.getTime()));
        }
        return cal;
    }

    public static String setScName(String id, String rank) {
        String scientificName = "";
        if (rank != null) {
            scientificName = rank.equals("family") ? Utils.getScientifiName(id, "family") : (rank.equals("genus") ? Utils.getScientifiName(id, "genus") : (rank.equals("species") ? Utils.getScientifiName(id, "genus") + " " + Utils.getScientifiName(id, "specificepithet") : Utils.getScientifiName(id, "scientificname")));
        }
        return scientificName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getScientifiName(String id, String rank) {
        String scientificName = "";
        ConnectionPool pool = null;
        Connection con = null;
        ResultSet results = null;
        try {
            pool = ConnectionPool.getConnectionPool();
            con = pool.getConnection();
            String query = "select " + rank + " from taxon where taxonid = ?";
            results = pool.selectPrestatement(query, id);
            if (results != null && results.next()) {
                scientificName = results.getString(1);
            }
            results.close();
        }
        catch (SQLException sqlExcept) {
            logger.error((Object)"sql Error", (Throwable)sqlExcept);
        }
        catch (ConnectionPoolException e) {
            logger.error((Object)"ConnectionPoolException", (Throwable)e);
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                logger.error((Object)"sql Error", (Throwable)e);
            }
            if (pool != null && con != null) {
                pool.releaseConnection(con);
            }
        }
        return scientificName;
    }

    public static String createDate() {
        Calendar now = Calendar.getInstance();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String date = format.format(now.getTime());
        return date;
    }

    public static String createCitation() {
        StringBuilder cit = new StringBuilder();
        cit.append("Accessed through: The Interim Register of Marine and Nonmarine Genera at http://www.obis.org.au/irmng/ on ");
        cit.append(Utils.createDate());
        return cit.toString();
    }

    public static String createCredits() {
        String cred = "This information object has been generated via the Species Product Discovery service on XDATEX by interfacing with the Interim Register of Marine and Nonmarine Genera (IRMNG) (http://www.obis.org.au/irmng/)";
        cred = cred.replace("XDATEX", Utils.createDate());
        return cred;
    }
}

