/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.data.spd.irmng;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.data.spd.irmng.Database;
import org.gcube.data.spd.irmng.Utils;
import org.gcube.data.spd.plugin.fwk.Properties;
import org.gcube.data.spd.plugin.fwk.Property;
import org.gcube.data.spd.plugin.fwk.capabilities.ClassificationCapability;
import org.gcube.data.spd.plugin.fwk.exceptions.ExternalRepositoryException;
import org.gcube.data.spd.plugin.fwk.exceptions.IdNotValidException;
import org.gcube.data.spd.plugin.fwk.exceptions.MethodNotSupportedException;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyItem;
import org.gcube.data.spd.plugin.fwk.model.TaxonomyStatus;
import org.gcube.data.spd.plugin.fwk.writers.ObjectWriter;

public class ClassificationCapabilityImpl
extends ClassificationCapability {
    GCUBELog logger = new GCUBELog(ClassificationCapabilityImpl.class);

    public Set<Properties> getSupportedProperties() {
        return Collections.emptySet();
    }

    public void getSynonymnsById(ObjectWriter<TaxonomyItem> writer, String id) throws IdNotValidException, MethodNotSupportedException, ExternalRepositoryException {
        this.logger.trace((Object)("getSynonimnsById " + id));
        ResultSet results = null;
        Database database = null;
        try {
            try {
                database = new Database();
                database.connect();
                this.logger.trace((Object)("select distinct(taxonid) from taxon where taxonomicstatus = 'synonym' and acceptednameusageid = '" + id + "'"));
                results = database.get("select distinct(taxonid) from taxon where taxonomicstatus = 'synonym' and acceptednameusageid = '" + id + "'");
                while (results.next()) {
                    TaxonomyItem tax = this.retrieveTaxonById(results.getString(1));
                    writer.put((Object)tax);
                }
            }
            catch (Throwable e) {
                this.logger.error((Object)"general Error", e);
                database.shutDown();
            }
        }
        finally {
            database.shutDown();
        }
    }

    public List<TaxonomyItem> retrieveTaxonChildsByTaxonId(String id_parent) {
        ArrayList<TaxonomyItem> list = new ArrayList<TaxonomyItem>();
        this.logger.trace((Object)("retrieveTaxonChildsByTaxonId " + id_parent));
        ResultSet results = null;
        Database database = null;
        try {
            try {
                database = new Database();
                database.connect();
                this.logger.trace((Object)("select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid, nameaccordingto  from taxon where parentnameusageid = '" + id_parent + "'"));
                results = database.get("select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid, nameaccordingto from taxon where parentnameusageid = '" + id_parent + "'");
                while (results.next()) {
                    TaxonomyItem item = this.createTaxonomyItem(results);
                    list.add(item);
                }
            }
            catch (SQLException sqlExcept) {
                this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
                try {
                    results.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"SQLException", (Throwable)e);
                }
                database.shutDown();
            }
            catch (Throwable e) {
                this.logger.error((Object)"general Error", e);
                try {
                    results.close();
                }
                catch (SQLException e2) {
                    this.logger.error((Object)"SQLException", (Throwable)e2);
                }
                database.shutDown();
            }
        }
        finally {
            try {
                results.close();
            }
            catch (SQLException e) {
                this.logger.error((Object)"SQLException", (Throwable)e);
            }
            database.shutDown();
        }
        return list;
    }

    private TaxonomyStatus setTaxStatus(String status, String syn_parent) {
        TaxonomyStatus tax = null;
        tax = status != null ? (status.equals("accepted") ? new TaxonomyStatus("accepted", TaxonomyStatus.Status.ACCEPTED) : (status.equals("valid") ? new TaxonomyStatus("valid", TaxonomyStatus.Status.VALID) : (status.equals("synonym") ? new TaxonomyStatus(TaxonomyStatus.Status.SYNONYM, syn_parent, "synonym") : new TaxonomyStatus(status, TaxonomyStatus.Status.UNKNOWN)))) : new TaxonomyStatus(status, TaxonomyStatus.Status.UNKNOWN);
        return tax;
    }

    public void searchByCommonName(String name, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
    }

    public void searchByScientificName(String scientificName, ObjectWriter<TaxonomyItem> writer, Property ... arg2) {
        this.logger.trace((Object)("searchByScientificName " + scientificName));
        ResultSet results = null;
        Database database = null;
        try {
            try {
                database = new Database();
                database.connect();
                results = database.get("select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid, nameaccordingto from taxon where UPPER(scientificname) like UPPER('%" + scientificName + "%')");
                while (results.next()) {
                    TaxonomyItem item = this.createTaxonomyItem(results);
                    writer.put((Object)item);
                }
            }
            catch (SQLException sqlExcept) {
                this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
                if (results != null) {
                    try {
                        results.close();
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)"sql Error", (Throwable)e);
                    }
                }
                database.shutDown();
                writer.close();
            }
        }
        finally {
            if (results != null) {
                try {
                    results.close();
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                }
            }
            database.shutDown();
            writer.close();
        }
    }

    public void retrieveTaxonByIds(Iterator<String> ids, ObjectWriter<TaxonomyItem> writer) {
        try {
            try {
                while (ids.hasNext()) {
                    String id = ids.next();
                    this.logger.trace((Object)("retrieveTaxonById " + id));
                    TaxonomyItem item = this.retrieveTaxonById(id);
                    writer.put((Object)item);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)"ExceptionPrintStackTrace", (Throwable)e);
                writer.close();
            }
        }
        finally {
            writer.close();
        }
    }

    private TaxonomyItem createTaxonomyItem(ResultSet result) throws SQLException {
        String id = result.getString(1);
        String rank = result.getString(2);
        String author = result.getString(3);
        String status = result.getString(4);
        Calendar modified = Utils.getCalendar(result.getString(5));
        String syn_parent = result.getString(6);
        String id_parent = result.getString(7);
        String citation = result.getString(8);
        TaxonomyItem item = new TaxonomyItem(id);
        item.setScientificName(Utils.setScName(id, rank));
        item.setAuthor(author);
        item.setCitation(citation);
        item.setRank(rank);
        item.setStatus(this.setTaxStatus(status, syn_parent));
        item.setModified(modified);
        if (id_parent != null) {
            try {
                item.setParent(this.retrieveTaxonById(id_parent));
            }
            catch (IdNotValidException e) {
                this.logger.error((Object)"Id Not Valid", (Throwable)e);
            }
        } else {
            item.setParent(null);
        }
        return item;
    }

    public TaxonomyItem retrieveTaxonById(String id) throws IdNotValidException {
        TaxonomyItem item;
        block14: {
            item = null;
            ResultSet results = null;
            Database database = null;
            try {
                try {
                    database = new Database();
                    database.connect();
                    results = database.get("select taxonid, taxonrank, scientificnameauthorship, taxonomicstatus, modified, acceptednameusageid, parentnameusageid, nameaccordingto from taxon where taxonid = '" + id + "'");
                    if (results.next()) {
                        item = this.createTaxonomyItem(results);
                        break block14;
                    }
                    this.logger.trace((Object)("id " + id + " not in IRMNG"));
                }
                catch (SQLException sqlExcept) {
                    this.logger.error((Object)"sql Error", (Throwable)sqlExcept);
                    try {
                        if (results != null) {
                            results.close();
                        }
                    }
                    catch (SQLException e) {
                        this.logger.error((Object)"sql Error", (Throwable)e);
                    }
                    database.shutDown();
                }
            }
            finally {
                try {
                    if (results != null) {
                        results.close();
                    }
                }
                catch (SQLException e) {
                    this.logger.error((Object)"sql Error", (Throwable)e);
                }
                database.shutDown();
            }
        }
        return item;
    }
}

